/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api.reservoir;

import cloud.metaapi.sdk.meta_api.reservoir.AvlTreeReservoir;
import java.util.Comparator;

public class NumberAvlTreeReservoir<T extends Number>
extends AvlTreeReservoir<T> {
    public NumberAvlTreeReservoir(Comparator<T> comparer, int reservoirSize) {
        this(comparer, reservoirSize, null, null);
    }

    public NumberAvlTreeReservoir(Comparator<T> comparer, int reservoirSize, Long storagePeriodInMilliseconds) {
        super(comparer, reservoirSize, storagePeriodInMilliseconds, null);
    }

    public NumberAvlTreeReservoir(Comparator<T> comparer, int reservoirSize, Long storagePeriodInMilliseconds, AvlTreeReservoir.RandomGenerator randomNumberGen) {
        super(comparer, reservoirSize, storagePeriodInMilliseconds, randomNumberGen);
    }

    public Double getPercentile(double percent) {
        this.removeOldRecords();
        double index = (double)(this.size() - 1) * percent / 100.0;
        int lower = (int)Math.floor(index);
        double fractionPart = index - (double)lower;
        Number item = (Number)this.valueTree.at(lower);
        if (item == null) {
            return null;
        }
        double percentile = item.doubleValue();
        if (fractionPart > 0.0) {
            percentile += fractionPart * (((Number)this.valueTree.at(lower + 1)).doubleValue() - ((Number)this.valueTree.at(lower)).doubleValue());
        }
        return percentile;
    }
}

