/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api.reservoir;

import cloud.metaapi.sdk.util.ServiceProvider;
import java.util.ArrayList;
import java.util.List;

public class Reservoir {
    public List<Statistics> array;
    public int size;
    public Statistics statistics;
    private int interval;
    private long queueEndTime;
    private int firstQueueIndex;
    private Statistics intermediaryRecord;

    public Reservoir(int size, int observationIntervalInMS) {
        this(size, observationIntervalInMS, null);
    }

    public Reservoir(int size, int observationIntervalInMS, Reservoir object) {
        if (object == null) {
            this.array = new ArrayList<Statistics>();
            this.size = size;
            this.interval = observationIntervalInMS / size;
            this.queueEndTime = ServiceProvider.getNow().toEpochMilli();
            this.firstQueueIndex = 0;
            this.intermediaryRecord = null;
            this.statistics = new Statistics(){
                {
                    this.count = 0;
                    this.sum = 0L;
                    this.max = null;
                    this.min = null;
                    this.average = 0.0;
                    this.sumOfSquares = 0;
                    this.msdev = 0.0;
                    this.stddev = 0.0;
                }
            };
        } else {
            this.array = object.array;
            this.size = object.size;
            this.interval = object.interval;
            this.queueEndTime = object.queueEndTime;
            this.firstQueueIndex = object.firstQueueIndex;
            this.intermediaryRecord = object.intermediaryRecord;
            this.statistics = this.checkStatisticsOnRestore(object.statistics);
        }
    }

    public Statistics checkStatisticsOnRestore(Statistics statistics) {
        if (statistics.count == 0) {
            statistics = new Statistics(){
                {
                    this.count = 0;
                    this.sum = 0L;
                    this.max = null;
                    this.min = null;
                    this.average = null;
                    this.sumOfSquares = 0;
                    this.msdev = null;
                    this.stddev = null;
                }
            };
        } else if (statistics.count < 2) {
            statistics.msdev = null;
            statistics.stddev = null;
        }
        return statistics;
    }

    public void pushMeasurement(long data) {
        this.updateQueue();
        this.updateIntermediaryRecord(data);
        this.updateStatisticsOnAdd(data);
    }

    public Statistics getStatistics() {
        this.updateQueue();
        return this.statistics;
    }

    private void updateQueue() {
        long intervalsCount = this.takeTimeIntervalsCount();
        long emptyElementsCount = this.takeEmptyElementsAddCount();
        if (emptyElementsCount > 0L) {
            this.addRecord(emptyElementsCount);
            this.queueEndTime += intervalsCount * (long)this.interval;
        }
    }

    private long takeEmptyElementsAddCount() {
        long emptyElementsCount = this.takeTimeIntervalsCount();
        if (emptyElementsCount > (long)this.size) {
            emptyElementsCount = this.size;
        }
        return emptyElementsCount;
    }

    private long takeTimeIntervalsCount() {
        long timeNow = ServiceProvider.getNow().toEpochMilli();
        long timeDiff = timeNow - this.queueEndTime;
        long timeIntervalCount = timeDiff / (long)this.interval;
        return timeIntervalCount;
    }

    private int updateRunningStatisticsOnRemove(long removeCount) {
        int removeElementIndex = this.firstQueueIndex + 1;
        int i = 0;
        while ((long)i < removeCount) {
            if (removeElementIndex >= this.size) {
                removeElementIndex = 0;
            }
            Statistics statistics = new Statistics(){
                {
                    this.count = 0;
                    this.sum = 0L;
                    this.max = null;
                    this.min = null;
                    this.average = 0.0;
                    this.sumOfSquares = 0;
                }
            };
            if (removeElementIndex < this.array.size()) {
                this.updateStatisticsOnRemove(this.array.get(removeElementIndex), removeElementIndex);
                this.array.set(removeElementIndex, statistics);
            } else {
                this.updateStatisticsOnRemove(null, removeElementIndex);
                this.array.add(statistics);
            }
            ++removeElementIndex;
            ++i;
        }
        if (--removeElementIndex < 0) {
            removeElementIndex = this.size - 1;
        }
        return removeElementIndex;
    }

    private void updateStatisticsOnRemove(Statistics removeElement, int removeElementIndex) {
        if (removeElement != null) {
            this.statistics.count -= removeElement.count;
            this.statistics.sumOfSquares -= removeElement.sumOfSquares;
            this.statistics.sum -= removeElement.sum;
            this.updateStatisticsMinAndMaxOnRemove(removeElement, removeElementIndex);
            if (this.statistics.count > 0) {
                this.statistics.average = (double)this.statistics.sum / (double)this.statistics.count;
                if (this.statistics.count > 1) {
                    double difOfSums = this.calculateDifferenceOfSums(this.statistics.sumOfSquares, this.statistics.sum, this.statistics.count);
                    this.statistics.msdev = Math.sqrt(difOfSums / (double)this.statistics.count);
                    this.statistics.stddev = Math.sqrt(difOfSums / (double)(this.statistics.count - 1));
                } else {
                    this.statistics.stddev = null;
                    this.statistics.msdev = null;
                }
            } else {
                this.statistics.average = null;
                this.statistics.stddev = null;
                this.statistics.msdev = null;
            }
        }
    }

    private void updateStatisticsMinAndMaxOnRemove(Statistics removeElement, int removeElementIndex) {
        if (removeElement.max != null && removeElement.max == this.statistics.max) {
            this.statistics.max = this.findMax(removeElementIndex);
        }
        if (removeElement.min != null && removeElement.min == this.statistics.min) {
            this.statistics.min = this.findMin(removeElementIndex);
        }
    }

    private void updateStatisticsOnAdd(long data) {
        ++this.statistics.count;
        this.statistics.sum += data;
        this.updateStatisticsMinAndMaxOnAdd(data);
        this.statistics.sumOfSquares = (int)((double)this.statistics.sumOfSquares + Math.pow(data, 2.0));
        if (this.statistics.count > 0) {
            this.statistics.average = (double)this.statistics.sum / (double)this.statistics.count;
            double difOfSums = this.calculateDifferenceOfSums(this.statistics.sumOfSquares, this.statistics.sum, this.statistics.count);
            if (this.statistics.count > 1) {
                this.statistics.msdev = Math.sqrt(difOfSums / (double)this.statistics.count);
                this.statistics.stddev = Math.sqrt(difOfSums / (double)(this.statistics.count - 1));
            } else {
                this.statistics.msdev = null;
                this.statistics.stddev = null;
            }
        }
    }

    private void updateStatisticsMinAndMaxOnAdd(long data) {
        if (this.statistics.max == null || this.statistics.max < data) {
            this.statistics.max = data;
        }
        if (this.statistics.min == null || this.statistics.min > data) {
            this.statistics.min = data;
        }
    }

    private void addRecord(long emptyElementsCount) {
        int curIndexInArray;
        if (this.intermediaryRecord != null) {
            if (this.array.size() == this.firstQueueIndex) {
                this.array.add(this.firstQueueIndex, this.intermediaryRecord);
            } else {
                this.array.set(this.firstQueueIndex, this.intermediaryRecord);
            }
            this.intermediaryRecord = null;
        }
        this.firstQueueIndex = curIndexInArray = this.updateRunningStatisticsOnRemove(emptyElementsCount);
    }

    private double calculateDifferenceOfSums(int sum1, long sum, int count) {
        double dif = (double)sum1 - Math.pow(sum, 2.0) / (double)count;
        return dif;
    }

    private void updateIntermediaryRecord(final long el) {
        if (this.intermediaryRecord == null) {
            this.intermediaryRecord = new Statistics(){
                {
                    this.count = 1;
                    this.sum = el;
                    this.max = el;
                    this.min = el;
                    this.average = el;
                    this.sumOfSquares = (int)Math.pow(el, 2.0);
                }
            };
        } else {
            if (this.intermediaryRecord.max < el) {
                this.intermediaryRecord.max = el;
            }
            if (this.intermediaryRecord.min > el) {
                this.intermediaryRecord.min = el;
            }
            ++this.intermediaryRecord.count;
            this.intermediaryRecord.sum += el;
            this.intermediaryRecord.sumOfSquares = (int)((double)this.intermediaryRecord.sumOfSquares + Math.pow(el, 2.0));
        }
    }

    private Long findMin(int index) {
        Long min = Long.MAX_VALUE;
        for (int i = 0; i < this.array.size(); ++i) {
            Statistics el = this.array.get(i);
            if (el == null || el.min == null || el.min >= min || i == index) continue;
            min = el.min;
        }
        if (min == Integer.MAX_VALUE) {
            return this.intermediaryRecord != null ? this.intermediaryRecord.min : null;
        }
        return min;
    }

    private Long findMax(int index) {
        Long max = Long.MIN_VALUE;
        for (int i = 0; i < this.array.size(); ++i) {
            Statistics el = this.array.get(i);
            if (el == null || el.max == null || el.max <= max || i == index) continue;
            max = el.max;
        }
        if (max == Integer.MIN_VALUE) {
            return this.intermediaryRecord != null ? this.intermediaryRecord.max : null;
        }
        return max;
    }

    public class Statistics {
        public int count;
        public long sum;
        public Long max;
        public Long min;
        public Double average;
        public int sumOfSquares;
        public Double msdev;
        public Double stddev;
    }
}

