/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api.reservoir;

import cloud.metaapi.sdk.meta_api.reservoir.AvlTreeReservoir;
import cloud.metaapi.sdk.meta_api.reservoir.NumberAvlTreeReservoir;
import java.util.List;

public class StatisticalReservoir {
    public NumberAvlTreeReservoir<Double> reservoir;
    public int length;

    public StatisticalReservoir(int size, Long interval) {
        this(size, interval, null);
    }

    public StatisticalReservoir(int size, Long interval, AvlTreeReservoir.RandomGenerator randomNumberGen) {
        this.reservoir = new NumberAvlTreeReservoir((a, b) -> a < b ? -1 : (a > b ? 1 : 0), size, interval, randomNumberGen);
        this.length = this.reservoir.size();
    }

    public StatisticalReservoir(int size, AvlTreeReservoir.RandomGenerator customRandomGenerator, Long interval) {
        this.reservoir = new NumberAvlTreeReservoir((a, b) -> a < b ? -1 : (a > b ? 1 : 0), size, interval, customRandomGenerator);
        this.length = this.reservoir.size();
    }

    public void pushMeasurement(double data) {
        this.reservoir.pushSome(data);
        this.length = this.reservoir.size();
    }

    public double getPercentile(double p) {
        this.length = this.reservoir.size();
        return this.reservoir.getPercentile(p);
    }

    public List<AvlTreeReservoir.Node> toList() {
        return this.reservoir.toList();
    }

    public List<Double> toValueList() {
        return this.reservoir.toValueList();
    }
}

