/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.util;

import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class Helpers {
    public static void wait(Supplier<Boolean> callable) throws InterruptedException, TimeoutException {
        Helpers.wait(callable, (Long)25L, new WaitOptions());
    }

    public static void wait(Supplier<Boolean> callable, Long intervalInMs) throws InterruptedException, TimeoutException {
        Helpers.wait(callable, intervalInMs, new WaitOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wait(Supplier<Boolean> callable, Long intervalInMs, WaitOptions options) throws InterruptedException, TimeoutException {
        boolean result = false;
        long timesAt = Date.from(Instant.now()).getTime() + options.timeoutInMs;
        while (!result && Date.from(Instant.now()).getTime() < timesAt) {
            try {
                result = callable.get();
            }
            catch (Throwable err) {
                if (Date.from(Instant.now()).getTime() < timesAt) continue;
                throw err;
            }
            finally {
                if (result) continue;
                Thread.sleep(intervalInMs);
            }
        }
        if (Date.from(Instant.now()).getTime() >= timesAt) {
            throw new TimeoutException("Timed out till specified callable returns true");
        }
    }

    public static void wait(Runnable callable) throws InterruptedException, TimeoutException {
        Helpers.wait(callable, (Long)25L);
    }

    public static void wait(Runnable callable, Long intervalInMs) throws InterruptedException, TimeoutException {
        Helpers.wait(callable, intervalInMs, new WaitOptions());
    }

    public static void wait(Runnable callable, Long intervalInMs, WaitOptions options) throws InterruptedException, TimeoutException {
        Helpers.wait(() -> {
            callable.run();
            return true;
        }, intervalInMs, options);
    }

    public static class WaitOptions {
        public long timeoutInMs = 30000L;
    }
}

