/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerProcessorEndState;
import cloud.piranha.http.api.HttpServerRequest;
import cloud.piranha.http.api.HttpServerResponse;
import cloud.piranha.http.impl.DefaultHttpServer;
import cloud.piranha.http.impl.DefaultHttpServerRequest;
import cloud.piranha.http.impl.DefaultHttpServerResponse;
import java.io.IOException;
import java.net.Socket;

class DefaultHttpServerProcessingThread
implements Runnable {
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServerProcessingThread.class.getName());
    private final DefaultHttpServer server;
    private final Socket socket;

    public DefaultHttpServerProcessingThread(DefaultHttpServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpServerProcessorEndState state = HttpServerProcessorEndState.COMPLETED;
        DefaultHttpServerResponse response = null;
        try {
            DefaultHttpServerRequest request = new DefaultHttpServerRequest(this.socket);
            response = new DefaultHttpServerResponse(this.socket);
            state = this.server.processor.process((HttpServerRequest)request, (HttpServerResponse)response);
        }
        finally {
            if (state == HttpServerProcessorEndState.COMPLETED) {
                try {
                    this.socket.shutdownInput();
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (response != null) {
                        response.closeResponse();
                    } else {
                        this.socket.close();
                    }
                }
                catch (IOException exception) {
                    LOGGER.log(System.Logger.Level.WARNING, "An I/O error occurred during processing of the request", (Throwable)exception);
                }
            }
        }
    }
}

