/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocket;

public class DefaultHttpServerRequest
implements HttpServerRequest {
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServerRequest.class.getName());
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>(1);
    private InputStream inputStream;
    private String method;
    private String requestTarget;
    private final Socket socket;
    private String protocol;

    public DefaultHttpServerRequest(Socket socket) {
        this.socket = socket;
        this.protocol = "HTTP/1.1";
        this.parse();
    }

    public void addHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.headers.put(name, values);
        } else {
            this.headers.get(name).add(value);
        }
    }

    public String getHeader(String name) {
        String header = null;
        if (this.headers.get(name) != null) {
            header = this.headers.get(name).isEmpty() ? null : this.headers.get(name).get(0);
        }
        return header;
    }

    public Iterator<String> getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public Iterator<String> getHeaders(String name) {
        return this.headers.get(name) == null ? new ArrayList().iterator() : this.headers.get(name).iterator();
    }

    public InputStream getInputStream() {
        InputStream result = this.inputStream;
        if (this.inputStream == null) {
            try {
                result = this.inputStream = this.socket.getInputStream();
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.WARNING, "An I/O error occurred while acquiring input stream", (Throwable)exception);
            }
        }
        return result;
    }

    public String getLocalAddress() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public String getLocalHostname() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHostname() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getRemotePort() {
        return this.socket.getPort();
    }

    public String getRequestTarget() {
        return this.requestTarget;
    }

    public boolean isSecure() {
        return this.socket instanceof SSLSocket;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setRequestTarget(String requestTarget) {
        this.requestTarget = requestTarget;
    }

    private void parse() {
        try {
            InputStream parseStream = this.socket.getInputStream();
            StringBuilder line = new StringBuilder();
            int read = parseStream.read();
            boolean requestLineParsed = false;
            if (read != -1) {
                while (read != -1 && parseStream.available() > 0) {
                    if ('\r' != (char)read) {
                        line.append((char)read);
                    }
                    if ('\n' != (char)(read = parseStream.read())) continue;
                    if (line.length() > 0) {
                        if (!requestLineParsed) {
                            this.parseRequestLine(line.toString());
                            requestLineParsed = true;
                        } else {
                            this.parseHeader(line.toString());
                        }
                        line = new StringBuilder();
                        read = parseStream.read();
                        continue;
                    }
                    read = -1;
                }
            }
        }
        catch (IOException exception) {
            LOGGER.log(System.Logger.Level.WARNING, "An I/O error occurred while parsing the request", (Throwable)exception);
        }
    }

    private void parseHeader(String line) {
        String name = line.substring(0, line.indexOf(58)).trim();
        String value = line.substring(line.indexOf(58) + 1).trim();
        this.addHeader(name, value);
    }

    private void parseRequestLine(String line) {
        int index = line.indexOf(32);
        this.setMethod(line.substring(0, index));
        line = line.substring(index + 1);
        index = line.indexOf(32);
        this.requestTarget = line.substring(0, index);
        String protocolRequestLine = line.substring(index + 1);
        if (!this.protocol.isEmpty()) {
            this.protocol = protocolRequestLine;
        }
    }
}

