/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpServerResponse
implements HttpServerResponse {
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServerResponse.class.getName());
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>(1);
    private OutputStream outputStream;
    private final Socket socket;
    private int status;

    public DefaultHttpServerResponse(Socket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String name, String value) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            DefaultHttpServerResponse defaultHttpServerResponse = this;
            synchronized (defaultHttpServerResponse) {
                values = new ArrayList<String>();
            }
        }
        values.add(value);
    }

    public void closeResponse() throws IOException {
        super.closeResponse();
        this.socket.close();
    }

    public String getHeader(String name) {
        return this.headers.get(name) == null ? null : this.headers.get(name).get(0);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                this.outputStream = this.socket.getOutputStream();
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.WARNING, () -> "An I/O error occurred while acquiring the output stream", (Throwable)exception);
            }
        }
        return this.outputStream;
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private void writeHeader(String name) throws IOException {
        OutputStream output = this.getOutputStream();
        output.write(name.getBytes());
        output.write(": ".getBytes());
        Iterator<String> values = this.headers.get(name).iterator();
        while (values.hasNext()) {
            output.write(values.next().getBytes());
            if (!values.hasNext()) continue;
            output.write(",".getBytes());
        }
        output.write("\n".getBytes());
    }

    public void writeHeaders() throws IOException {
        for (String name : this.headers.keySet()) {
            this.writeHeader(name);
        }
        OutputStream output = this.getOutputStream();
        output.write("\n".getBytes());
    }

    public void writeStatusLine() throws IOException {
        OutputStream output = this.getOutputStream();
        output.write("HTTP/1.0".getBytes());
        output.write(" ".getBytes());
        output.write(Integer.toString(this.status).getBytes());
        output.write("\n".getBytes());
    }
}

