/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServer;
import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.impl.DefaultHttpServerAcceptorThread;
import cloud.piranha.http.impl.DefaultHttpServerThreadFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class DefaultHttpServer
implements HttpServer {
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServer.class.getName());
    protected ExecutorService executorService;
    protected HttpServerProcessor processor;
    protected int serverPort;
    protected Thread serverAcceptorThread;
    protected ServerSocket serverSocket;
    protected boolean serverStopRequest;
    protected int soTimeout;
    protected boolean ssl;
    protected ThreadFactory threadFactory;

    public DefaultHttpServer() {
        this.threadFactory = new DefaultHttpServerThreadFactory();
        this.serverPort = 8765;
        this.serverStopRequest = false;
    }

    public DefaultHttpServer(int serverPort) {
        this.serverPort = serverPort;
        this.threadFactory = new DefaultHttpServerThreadFactory();
    }

    public DefaultHttpServer(int serverPort, HttpServerProcessor processor, boolean ssl) {
        this.threadFactory = new DefaultHttpServerThreadFactory();
        this.processor = processor;
        this.serverPort = serverPort;
        this.serverStopRequest = false;
        this.ssl = ssl;
    }

    public DefaultHttpServer(int serverPort, HttpServerProcessor processor, int soTimeout) {
        this.threadFactory = new DefaultHttpServerThreadFactory();
        this.processor = processor;
        this.serverPort = serverPort;
        this.serverStopRequest = false;
        this.soTimeout = soTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isRunning() {
        boolean result = false;
        if (this.executorService != null) {
            result = !this.executorService.isShutdown();
        }
        return result;
    }

    public void start() {
        LOGGER.log(System.Logger.Level.DEBUG, () -> "Starting HTTP server on port " + this.serverPort);
        try {
            this.executorService = Executors.newCachedThreadPool(this.threadFactory);
            this.serverStopRequest = false;
            if (this.ssl) {
                SSLContext context = SSLContext.getDefault();
                SSLEngine engine = context.createSSLEngine();
                SSLServerSocketFactory factory = context.getServerSocketFactory();
                SSLServerSocket socket = (SSLServerSocket)factory.createServerSocket(this.serverPort);
                SSLParameters parameters = new SSLParameters();
                parameters.setCipherSuites(engine.getSupportedCipherSuites());
                parameters.setProtocols(engine.getSupportedProtocols());
                parameters.setNeedClientAuth(false);
                parameters.setWantClientAuth(true);
                socket.setSSLParameters(parameters);
                this.serverSocket = socket;
            } else {
                this.serverSocket = new ServerSocket(this.serverPort);
            }
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.setSoTimeout(this.soTimeout);
            this.serverAcceptorThread = new Thread((Runnable)new DefaultHttpServerAcceptorThread(this), "DefaultHttpServer-AcceptorThread");
            this.serverAcceptorThread.start();
            LOGGER.log(System.Logger.Level.DEBUG, () -> "Started HTTP server on port " + this.serverPort);
        }
        catch (IOException exception) {
            LOGGER.log(System.Logger.Level.WARNING, "An I/O error occurred while starting the HTTP server", (Throwable)exception);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.log(System.Logger.Level.WARNING, "Unable to match SSL algorithm", (Throwable)ex);
        }
    }

    public void stop() {
        LOGGER.log(System.Logger.Level.DEBUG, () -> "Stopping HTTP server on port " + this.serverPort);
        this.serverStopRequest = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.WARNING, "An I/O error occurred while stopping the HTTP server", (Throwable)exception);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exception) {
                LOGGER.log(System.Logger.Level.WARNING, "Termination of the executor service was interrupted", (Throwable)exception);
                Thread.currentThread().interrupt();
            }
        }
        LOGGER.log(System.Logger.Level.DEBUG, () -> "Stopped HTTP server on port " + this.serverPort);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean getSSL() {
        return this.ssl;
    }

    public void setHttpServerProcessor(HttpServerProcessor httpServerProcessor) {
        this.processor = httpServerProcessor;
    }

    public HttpServerProcessor getHttpServerProcessor() {
        return this.processor;
    }
}

