/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.api.HttpServerProcessorEndState;
import cloud.piranha.http.api.HttpServerRequest;
import cloud.piranha.http.api.HttpServerResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DefaultHttpServerProcessor
implements HttpServerProcessor {
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServerProcessor.class.getName());
    private static final String IO_ERROR_WRITING_RESPONSE = "An I/O error occurred while writing the response";

    public HttpServerProcessorEndState process(HttpServerRequest request, HttpServerResponse response) {
        response.setStatus(200);
        File baseDir = new File(System.getProperty("user.dir"));
        File file = new File(baseDir, request.getRequestTarget());
        if (file.exists() && file.isDirectory() && "GET".equals(request.getMethod())) {
            response.setHeader("Content-Type", "text/html");
            try {
                response.writeStatusLine();
                response.writeHeaders();
                OutputStream outputStream = response.getOutputStream();
                PrintWriter writer = new PrintWriter(outputStream);
                writer.println("<html><head></head><body>");
                writer.println(file.getName() + "<br/>");
                writer.print("<a href=\".\">.</a><br/>");
                writer.print("<a href=\"..\">..</a><br/>");
                File[] fileList = file.listFiles();
                if (fileList != null && fileList.length > 0) {
                    for (int i = 0; i < fileList.length; ++i) {
                        String uri = fileList[i].getAbsolutePath().substring(baseDir.getAbsolutePath().length());
                        if (uri.startsWith("//")) {
                            uri = uri.substring(1);
                        }
                        writer.println("<a href=\"http://" + request.getLocalHostname() + ":" + request.getLocalPort() + uri + "\">" + fileList[i].getName() + "</a><br/>");
                    }
                }
                writer.println("</body></html>");
                writer.flush();
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.ERROR, IO_ERROR_WRITING_RESPONSE, (Throwable)exception);
            }
        } else if (file.exists() && !file.isDirectory()) {
            response.setHeader("Content-Type", "application/octet-stream");
            response.setHeader("Content-Length", Long.toString(file.length()));
            try {
                response.writeStatusLine();
                response.writeHeaders();
                OutputStream outputStream = response.getOutputStream();
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                    int read = ((InputStream)inputStream).read();
                    while (read != -1) {
                        outputStream.write((char)read);
                        read = ((InputStream)inputStream).read();
                    }
                    outputStream.flush();
                }
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.ERROR, IO_ERROR_WRITING_RESPONSE, (Throwable)exception);
            }
        } else {
            try {
                response.setStatus(404);
                response.writeStatusLine();
                response.writeHeaders();
            }
            catch (IOException exception) {
                LOGGER.log(System.Logger.Level.ERROR, IO_ERROR_WRITING_RESPONSE, (Throwable)exception);
            }
        }
        return HttpServerProcessorEndState.COMPLETED;
    }
}

