/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.http.api.HttpServer;
import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.netty.NettyHttpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public class NettyHttpServer
implements HttpServer {
    private EventLoopGroup bossGroup;
    private HttpServerProcessor httpServerProcessor;
    private int serverPort;
    private EventLoopGroup workerGroup;
    private boolean ssl;

    public NettyHttpServer() {
        this.serverPort = 8080;
    }

    public NettyHttpServer(int serverPort) {
        this.serverPort = serverPort;
    }

    public NettyHttpServer(int serverPort, HttpServerProcessor httpServerProcessor) {
        this.httpServerProcessor = httpServerProcessor;
        this.serverPort = serverPort;
    }

    public boolean isRunning() {
        return this.bossGroup != null && this.workerGroup != null;
    }

    public void start() {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new NettyHttpServerInitializer(this.httpServerProcessor, this.ssl)).bind(this.serverPort).awaitUninterruptibly();
    }

    public void stop() {
        this.workerGroup.shutdownGracefully().awaitUninterruptibly();
        this.bossGroup.shutdownGracefully().awaitUninterruptibly();
        this.bossGroup = null;
        this.workerGroup = null;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean getSSL() {
        return this.ssl;
    }

    public void setHttpServerProcessor(HttpServerProcessor httpServerProcessor) {
        this.httpServerProcessor = httpServerProcessor;
    }

    public HttpServerProcessor getHttpServerProcessor() {
        return this.httpServerProcessor;
    }
}

