/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.api.HttpServerRequest;
import cloud.piranha.http.api.HttpServerResponse;
import cloud.piranha.http.netty.NettyHttpServerRequest;
import cloud.piranha.http.netty.NettyHttpServerResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final System.Logger LOGGER = System.getLogger(NettyHttpServerHandler.class.getName());
    private final HttpServerProcessor httpServerProcessor;
    private final boolean secure;

    public NettyHttpServerHandler(HttpServerProcessor httpServerProcessor, boolean secure) {
        this.httpServerProcessor = httpServerProcessor;
        this.secure = secure;
    }

    public void channelReadComplete(ChannelHandlerContext context) {
        context.flush();
    }

    protected void channelRead0(ChannelHandlerContext context, FullHttpRequest object) {
        NettyHttpServerRequest nettyRequest = new NettyHttpServerRequest(context, object, this.secure);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, true);
        NettyHttpServerResponse nettyResponse = new NettyHttpServerResponse((FullHttpResponse)response);
        this.httpServerProcessor.process((HttpServerRequest)nettyRequest, (HttpServerResponse)nettyResponse);
        ChannelFuture future = context.channel().writeAndFlush((Object)response);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable throwable) {
        LOGGER.log(System.Logger.Level.WARNING, "Exception caught in NettyHttpServerHandler", throwable);
        context.close();
    }
}

