/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.http.api.HttpServerProcessor;
import cloud.piranha.http.netty.NettyHttpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

@ChannelHandler.Sharable
public class NettyHttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final System.Logger LOGGER = System.getLogger(NettyHttpServerInitializer.class.getName());
    private final HttpServerProcessor httpServerProcessor;
    private final boolean ssl;

    public NettyHttpServerInitializer(HttpServerProcessor httpServerProcessor, boolean ssl) {
        this.httpServerProcessor = httpServerProcessor;
        this.ssl = ssl;
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.ssl) {
            try {
                SSLContext sslContext = SSLContext.getDefault();
                SSLEngine sslEngine = sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Unable to match SSL algorithm", (Throwable)e);
            }
        }
        pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
        pipeline.addLast(new ChannelHandler[]{new NettyHttpServerHandler(this.httpServerProcessor, this.ssl)});
    }
}

