/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.netty;

import cloud.piranha.http.api.HttpServerRequest;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Iterator;

public class NettyHttpServerRequest
implements HttpServerRequest {
    private final ChannelHandlerContext context;
    private InputStream inputStream;
    private final FullHttpRequest request;
    private final boolean secure;

    public NettyHttpServerRequest(ChannelHandlerContext context, FullHttpRequest request, boolean secure) {
        this.context = context;
        this.request = request;
        this.secure = secure;
    }

    public String getHeader(String name) {
        return this.request.headers().get(name);
    }

    public Iterator<String> getHeaderNames() {
        return this.request.headers().names().iterator();
    }

    public Iterator<String> getHeaders(String name) {
        return this.request.headers().getAll(name).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        FullHttpRequest fullHttpRequest = this.request;
        synchronized (fullHttpRequest) {
            if (this.inputStream == null) {
                this.inputStream = new ByteBufInputStream(this.request.content());
            }
        }
        return this.inputStream;
    }

    public String getLocalAddress() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getAddress().getHostAddress();
    }

    public String getLocalHostname() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getAddress().getHostName();
    }

    public int getLocalPort() {
        InetSocketAddress localAddress = (InetSocketAddress)this.context.channel().localAddress();
        return localAddress.getPort();
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public String getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    public String getRemoteHostname() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getAddress().getHostName();
    }

    public int getRemotePort() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.context.channel().remoteAddress();
        return remoteAddress.getPort();
    }

    public String getRequestTarget() {
        return this.request.uri();
    }

    public String getProtocol() {
        return this.request.protocolVersion().text();
    }

    public boolean isSecure() {
        return this.secure;
    }
}

