/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigValueUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigValueUtils.class);

    public static Prefab.ConfigValue from(String string) {
        return Prefab.ConfigValue.newBuilder().setString(string).build();
    }

    public static Prefab.ConfigValue from(List<String> stringList) {
        return Prefab.ConfigValue.newBuilder().setStringList(Prefab.StringList.newBuilder().addAllValues(stringList)).build();
    }

    public static Prefab.ConfigValue from(boolean bool) {
        return Prefab.ConfigValue.newBuilder().setBool(bool).build();
    }

    public static Prefab.ConfigValue from(long number) {
        return Prefab.ConfigValue.newBuilder().setInt(number).build();
    }

    public static Prefab.ConfigValue from(int number) {
        return Prefab.ConfigValue.newBuilder().setInt(number).build();
    }

    public static Prefab.ConfigValue from(double number) {
        return Prefab.ConfigValue.newBuilder().setDouble(number).build();
    }

    public static Map<String, Prefab.ConfigValue> fromStringMap(Map<String, String> stringStringMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> stringStringEntry : stringStringMap.entrySet()) {
            builder.put((Object)stringStringEntry.getKey(), (Object)ConfigValueUtils.fromString(stringStringEntry.getValue()));
        }
        return builder.build();
    }

    public static Optional<String> coerceToString(Prefab.ConfigValue configValue) {
        switch (configValue.getTypeCase()) {
            case STRING: {
                return Optional.of(configValue.getString());
            }
            case DOUBLE: {
                return Optional.of(String.valueOf(configValue.getDouble()));
            }
            case INT: {
                return Optional.of(String.valueOf(configValue.getInt()));
            }
            case BOOL: {
                return Optional.of(String.valueOf(configValue.getBool()));
            }
            case LOG_LEVEL: {
                return Optional.of(configValue.getLogLevel().name());
            }
            case STRING_LIST: {
                return Optional.of(configValue.getStringList().getValuesList().stream().collect(Collectors.joining(",")));
            }
        }
        LOG.debug("Encountered unexpected type {} of configValue to coerce to string", (Object)configValue.getTypeCase());
        return Optional.empty();
    }

    public static Optional<Object> asObject(Prefab.ConfigValue configValue) {
        switch (configValue.getTypeCase()) {
            case STRING: {
                return Optional.of(configValue.getString());
            }
            case DOUBLE: {
                return Optional.of(configValue.getDouble());
            }
            case INT: {
                return Optional.of(configValue.getInt());
            }
            case BOOL: {
                return Optional.of(configValue.getBool());
            }
            case LOG_LEVEL: {
                return Optional.of(configValue.getLogLevel());
            }
            case STRING_LIST: {
                return Optional.of(configValue.getStringList().getValuesList());
            }
        }
        LOG.debug("Encountered unexpected type {} of configValue to coerce to string", (Object)configValue.getTypeCase());
        return Optional.empty();
    }

    @Deprecated
    public static Prefab.ConfigValue fromString(String string) {
        return ConfigValueUtils.from(string);
    }
}

