/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.domain.Prefab;
import com.google.common.base.MoreObjects;
import java.util.Optional;

public class EvaluatedCriterion {
    private final Prefab.Criterion criterion;
    private final Optional<Prefab.ConfigValue> evaluatedProperty;
    private final boolean match;

    public EvaluatedCriterion(Prefab.Criterion criterion, String evaluatedProperty, boolean match) {
        this(criterion, Prefab.ConfigValue.newBuilder().setString(evaluatedProperty).build(), match);
    }

    public EvaluatedCriterion(Prefab.Criterion criterion, Prefab.ConfigValue evaluatedProperty, boolean match) {
        this.criterion = criterion;
        this.evaluatedProperty = Optional.of(evaluatedProperty);
        this.match = match;
    }

    public EvaluatedCriterion(Prefab.Criterion criterion, Optional<Prefab.ConfigValue> evaluatedProperty, boolean match) {
        this.criterion = criterion;
        this.evaluatedProperty = evaluatedProperty;
        this.match = match;
    }

    public EvaluatedCriterion(Prefab.Criterion criterion, boolean match) {
        this.criterion = criterion;
        this.evaluatedProperty = Optional.empty();
        this.match = match;
    }

    public Prefab.Criterion getCriterion() {
        return this.criterion;
    }

    public Optional<Prefab.ConfigValue> getEvaluatedProperty() {
        return this.evaluatedProperty;
    }

    public boolean isMatch() {
        return this.match;
    }

    public EvaluatedCriterion negated() {
        return new EvaluatedCriterion(this.criterion, this.evaluatedProperty, !this.match);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("criterion", (Object)this.criterion).add("evaluatedProperty", this.evaluatedProperty).add("match", this.match).toString();
    }
}

