/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config;

import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.EvaluatedCriterion;
import cloud.prefab.domain.Prefab;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;

public class Match {
    private final Prefab.ConfigValue configValue;
    private final ConfigElement configElement;
    private final List<EvaluatedCriterion> evaluatedCriterion;
    private final int rowIndex;
    private final int conditionalValueIndex;
    private final Optional<Integer> weightedValueIndex;

    public Match(Prefab.ConfigValue configValue, ConfigElement configElement, List<EvaluatedCriterion> evaluatedCriterion, int rowIndex, int conditionalValueIndex, Optional<Integer> weightedValueIndex) {
        this.configValue = configValue;
        this.configElement = configElement;
        this.evaluatedCriterion = evaluatedCriterion;
        this.rowIndex = rowIndex;
        this.conditionalValueIndex = conditionalValueIndex;
        this.weightedValueIndex = weightedValueIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getConditionalValueIndex() {
        return this.conditionalValueIndex;
    }

    public Optional<Integer> getWeightedValueIndex() {
        return this.weightedValueIndex;
    }

    public Prefab.ConfigValue getConfigValue() {
        return this.configValue;
    }

    public ConfigElement getConfigElement() {
        return this.configElement;
    }

    public String getReason() {
        StringBuilder sb = new StringBuilder();
        this.evaluatedCriterion.forEach(ec -> {
            sb.append(ec.getCriterion().getPropertyName());
            sb.append(":");
            sb.append((Object)ec.getCriterion().getOperator());
        });
        return sb.toString();
    }

    public List<EvaluatedCriterion> getEvaluatedCriterion() {
        return this.evaluatedCriterion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("configElement", (Object)this.configElement).add("configValue", (Object)this.configValue).add("evaluatedCriterion", this.evaluatedCriterion).add("rowIndex", this.rowIndex).add("conditionalValueIndex", this.conditionalValueIndex).add("weightedValueIndex", this.weightedValueIndex).toString();
    }
}

