/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config.logging;

import cloud.prefab.client.config.ConfigChangeListener;
import cloud.prefab.client.config.logging.AbstractLoggingListener;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLoggingConfigListener
extends AbstractLoggingListener<Level> {
    private static final ConfigChangeListener INSTANCE = new JavaUtilLoggingConfigListener();
    private static final String ROOT_LOGGER = "";
    private static final Map<Prefab.LogLevel, Level> LEVEL_MAP = ImmutableMap.builder().put((Object)Prefab.LogLevel.FATAL, (Object)Level.SEVERE).put((Object)Prefab.LogLevel.ERROR, (Object)Level.SEVERE).put((Object)Prefab.LogLevel.WARN, (Object)Level.WARNING).put((Object)Prefab.LogLevel.INFO, (Object)Level.INFO).put((Object)Prefab.LogLevel.DEBUG, (Object)Level.FINE).put((Object)Prefab.LogLevel.TRACE, (Object)Level.FINER).build();

    public static ConfigChangeListener getInstance() {
        return INSTANCE;
    }

    private JavaUtilLoggingConfigListener() {
    }

    @Override
    protected Map<Prefab.LogLevel, Level> getValidLevels() {
        return LEVEL_MAP;
    }

    @Override
    protected void setDefaultLevel(Optional<Level> level) {
        this.setLevel(ROOT_LOGGER, level);
    }

    @Override
    protected void setLevel(String loggerName, Optional<Level> level) {
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(level.orElse(null));
    }
}

