/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.Options;
import cloud.prefab.client.PrefabCloudClient;
import cloud.prefab.client.PrefabInitializationTimeoutException;
import cloud.prefab.client.config.ConfigChangeEvent;
import cloud.prefab.client.config.ConfigChangeListener;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.internal.ConfigLoader;
import cloud.prefab.client.internal.ConfigStoreDeltaCalculator;
import cloud.prefab.client.internal.ConnectivityTester;
import cloud.prefab.client.internal.ContextShapeAggregator;
import cloud.prefab.client.internal.ExampleContextBuffer;
import cloud.prefab.client.internal.LoggerStatsAggregator;
import cloud.prefab.client.internal.LoggingConfigListener;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.MatchStatsAggregator;
import cloud.prefab.client.internal.PrefabHttpClient;
import cloud.prefab.client.internal.SseConfigStreamingSubscriber;
import cloud.prefab.client.internal.TelemetryManager;
import cloud.prefab.client.internal.UpdatingConfigResolver;
import cloud.prefab.client.internal.WeightedValueEvaluator;
import cloud.prefab.client.value.LiveBoolean;
import cloud.prefab.client.value.LiveDouble;
import cloud.prefab.client.value.LiveLong;
import cloud.prefab.client.value.LiveString;
import cloud.prefab.client.value.LiveStringList;
import cloud.prefab.client.value.Value;
import cloud.prefab.context.ContextStore;
import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigClientImpl
implements ConfigClient {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigClientImpl.class);
    private static final long DEFAULT_CHECKPOINT_SEC = 60L;
    private static final String LOG_LEVEL_PREFIX_WITH_DOT = "log-level.";
    private final Options options;
    private final UpdatingConfigResolver updatingConfigResolver;
    private final CountDownLatch initializedLatch = new CountDownLatch(1);
    private final Set<ConfigChangeListener> configChangeListeners = Sets.newConcurrentHashSet();
    private final String uniqueClientId;
    private final Optional<Prefab.ConfigValue> namespaceMaybe;
    private final ConcurrentHashMap<String, String> loggerNameLookup = new ConcurrentHashMap();
    private final PrefabHttpClient prefabHttpClient;
    private final ContextStore contextStore;
    private final TelemetryManager telemetryManager;

    public ConfigClientImpl(PrefabCloudClient baseClient, ConfigChangeListener ... listeners) {
        this(baseClient, new UpdatingConfigResolver(new ConfigLoader(baseClient.getOptions()), new WeightedValueEvaluator(), new ConfigStoreDeltaCalculator()), listeners);
    }

    @VisibleForTesting
    ConfigClientImpl(PrefabCloudClient baseClient, UpdatingConfigResolver updatingConfigResolver, ConfigChangeListener ... listeners) {
        this.uniqueClientId = UUID.randomUUID().toString();
        this.options = baseClient.getOptions();
        this.updatingConfigResolver = updatingConfigResolver;
        this.configChangeListeners.add(new LoggingConfigListener(() -> this.initializedLatch.getCount() == 0L));
        this.configChangeListeners.addAll(baseClient.getOptions().getChangeListeners());
        this.configChangeListeners.addAll(Arrays.asList(listeners));
        this.namespaceMaybe = baseClient.getOptions().getNamespace().map(ns -> Prefab.ConfigValue.newBuilder().setString((String)ns).build());
        this.contextStore = this.options.getContextStore();
        if (this.options.isLocalOnly()) {
            this.finishInit(ConfigClient.Source.LOCAL_ONLY);
            this.prefabHttpClient = null;
            this.telemetryManager = null;
        } else if (this.options.isLocalDatafileMode()) {
            updatingConfigResolver.loadConfigsFromLocalFile();
            this.finishInit(ConfigClient.Source.LOCAL_FILE);
            this.prefabHttpClient = null;
            this.telemetryManager = null;
        } else {
            HttpClient httpClient = HttpClient.newBuilder().executor(MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefab-http-client-pooled-thread-%d").build())))).build();
            ConnectivityTester connectivityTester = new ConnectivityTester(httpClient, this.options);
            connectivityTester.testHttps();
            this.prefabHttpClient = new PrefabHttpClient(httpClient, this.options);
            this.startStreaming();
            this.startCheckpointExecutor();
            this.telemetryManager = new TelemetryManager(new LoggerStatsAggregator(Clock.systemUTC()), new MatchStatsAggregator(), new ContextShapeAggregator(), new ExampleContextBuffer(), this.prefabHttpClient, this.options, Clock.systemUTC());
            this.telemetryManager.start();
        }
    }

    @Override
    public Value<String> liveString(String key) {
        return new LiveString(this, key);
    }

    @Override
    public Value<List<String>> liveStringList(String key) {
        return new LiveStringList(this, key);
    }

    @Override
    public Value<Long> liveLong(String key) {
        return new LiveLong(this, key);
    }

    @Override
    public Value<Double> liveDouble(String key) {
        return new LiveDouble(this, key);
    }

    @Override
    public Value<Boolean> liveBoolean(String key) {
        return new LiveBoolean(this, key);
    }

    @Override
    public Optional<Prefab.ConfigValue> get(String key) {
        return this.get(key, (PrefabContextSetReadable)null);
    }

    @Override
    public Optional<Prefab.ConfigValue> get(String configKey, Map<String, Prefab.ConfigValue> properties) {
        return this.get(configKey, PrefabContext.unnamedFromMap(properties));
    }

    @Override
    public Optional<Prefab.ConfigValue> get(String configKey, @Nullable PrefabContextSetReadable prefabContext) {
        PrefabContextSetReadable resolvedContext = this.resolveContext(prefabContext);
        LookupContext lookupContext = new LookupContext(this.namespaceMaybe, resolvedContext);
        return this.getInternal(configKey, lookupContext);
    }

    @Override
    public Map<String, Prefab.ConfigValue> getAll(@Nullable PrefabContextSetReadable prefabContext) {
        LookupContext lookupContext = new LookupContext(this.namespaceMaybe, this.resolveContext(prefabContext));
        ImmutableMap.Builder bldr = ImmutableMap.builder();
        for (String key : this.getAllKeys()) {
            this.updatingConfigResolver.getConfigValue(key, lookupContext).ifPresent(configValue -> bldr.put((Object)key, configValue));
        }
        return bldr.build();
    }

    @Override
    public Collection<String> getAllKeys() {
        return this.updatingConfigResolver.getResolver().getKeys();
    }

    private Optional<Prefab.ConfigValue> getInternal(String configKey, LookupContext lookupContext) {
        this.waitForInitialization();
        Optional<Match> matchMaybe = this.getMatchInternal(configKey, lookupContext);
        this.reportMatchResult(configKey, matchMaybe.orElse(null), lookupContext);
        return matchMaybe.map(Match::getConfigValue);
    }

    private void reportMatchResult(String configKey, @Nullable Match match, LookupContext lookupContext) {
        if (this.telemetryManager != null) {
            this.telemetryManager.reportMatch(configKey, match, lookupContext);
        }
    }

    private Optional<Match> getMatchInternal(String configKey, LookupContext lookupContext) {
        this.waitForInitialization();
        return this.updatingConfigResolver.getMatch(configKey, lookupContext);
    }

    @Override
    public boolean addConfigChangeListener(ConfigChangeListener configChangeListener) {
        return this.configChangeListeners.add(configChangeListener);
    }

    @Override
    public boolean removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        return this.configChangeListeners.remove(configChangeListener);
    }

    @Override
    public void reportLoggerUsage(String loggerName, Prefab.LogLevel logLevel, long count) {
        if (logLevel != null && this.telemetryManager != null) {
            this.telemetryManager.reportLoggerUsage(loggerName, logLevel, count);
        }
    }

    @Override
    public Optional<Prefab.LogLevel> getLogLevel(String loggerName) {
        return this.getLogLevel(loggerName, null);
    }

    @Override
    public Optional<Prefab.LogLevel> getLogLevel(String loggerName, @Nullable PrefabContextSetReadable prefabContext) {
        LookupContext lookupContext = new LookupContext(this.namespaceMaybe, this.resolveContext(prefabContext));
        Iterator<String> it = this.loggerNameLookupIterator(loggerName);
        while (it.hasNext()) {
            String configKey = it.next();
            Optional<Prefab.LogLevel> logLevelMaybe = this.getInternal(configKey, lookupContext).filter(Prefab.ConfigValue::hasLogLevel).map(Prefab.ConfigValue::getLogLevel);
            if (!logLevelMaybe.isPresent()) continue;
            return logLevelMaybe;
        }
        return Optional.empty();
    }

    private PrefabContextSetReadable resolveContext(@Nullable PrefabContextSetReadable prefabContextSetReadable) {
        Optional<PrefabContextSetReadable> newContext = Optional.ofNullable(prefabContextSetReadable).filter(Predicate.not(PrefabContextSetReadable::isEmpty));
        Optional<PrefabContextSetReadable> existingContext = this.getContextStore().getContext().filter(Predicate.not(PrefabContextSetReadable::isEmpty));
        if (LOG.isTraceEnabled()) {
            LOG.trace("context store contains {}, after filtering {}", (Object)this.getContextStore().getContext().map(Object::toString).orElse("n/a"), (Object)existingContext.map(Object::toString).orElse("n/a"));
            LOG.trace("Merging passed context {} with context store {}", (Object)prefabContextSetReadable, (Object)this.getContextStore().getContext().map(Object::toString).orElse("n/a"));
        }
        if (newContext.isEmpty()) {
            return existingContext.orElse(PrefabContextSetReadable.EMPTY);
        }
        if (existingContext.isEmpty()) {
            return newContext.get();
        }
        PrefabContextSet prefabContextSet = new PrefabContextSet();
        for (PrefabContext context : existingContext.get().getContexts()) {
            prefabContextSet.addContext(context);
        }
        for (PrefabContext context : newContext.get().getContexts()) {
            prefabContextSet.addContext(context);
        }
        return prefabContextSet;
    }

    @Override
    public boolean isReady() {
        return this.initializedLatch.getCount() == 0L;
    }

    @Override
    public ContextStore getContextStore() {
        return this.contextStore;
    }

    private Iterator<String> loggerNameLookupIterator(final String loggerName) {
        return new Iterator<String>(){
            String nextValue;
            {
                this.nextValue = ConfigClientImpl.LOG_LEVEL_PREFIX_WITH_DOT + loggerName;
            }

            @Override
            public boolean hasNext() {
                return this.nextValue != null;
            }

            @Override
            public String next() {
                if (this.nextValue == null) {
                    throw new NoSuchElementException();
                }
                String currentValue = this.nextValue;
                String temp = ConfigClientImpl.this.loggerNameLookup.get(currentValue);
                this.nextValue = temp == null ? ConfigClientImpl.this.loggerNameLookup.computeIfAbsent(currentValue, k -> {
                    int lastDotIndex = this.nextValue.lastIndexOf(46);
                    if (lastDotIndex > 0) {
                        return this.nextValue.substring(0, lastDotIndex);
                    }
                    return null;
                }) : temp;
                return currentValue;
            }
        };
    }

    private void loadCheckpoint() {
        boolean cdnSuccess = this.loadCDN();
        if (cdnSuccess) {
            return;
        }
        this.loadAPI();
    }

    boolean loadCDN() {
        try {
            HttpResponse<Supplier<Prefab.Configs>> response = this.prefabHttpClient.requestConfigsFromCDN(0L).get(5L, TimeUnit.SECONDS);
            if (PrefabHttpClient.isSuccess(response.statusCode())) {
                this.loadConfigs(response.body().get(), ConfigClient.Source.REMOTE_CDN);
                return true;
            }
            LOG.info("Got {} loading configs from CDN url {}", (Object)response.statusCode(), (Object)response.request().uri());
        }
        catch (Exception e) {
            LOG.info("Got exception with message {} loading configs from CDN", (Object)e.getMessage());
        }
        return false;
    }

    boolean loadAPI() {
        try {
            HttpResponse<Supplier<Prefab.Configs>> response = this.prefabHttpClient.requestConfigsFromApi(0L).get(5L, TimeUnit.SECONDS);
            if (PrefabHttpClient.isSuccess(response.statusCode())) {
                this.loadConfigs(response.body().get(), ConfigClient.Source.REMOTE_API);
                return true;
            }
            LOG.info("Got {} loading configs from API url {}", (Object)response.statusCode(), (Object)response.request().uri());
        }
        catch (Exception e) {
            LOG.info("Got exception with message {} loading configs from API", (Object)e.getMessage());
        }
        return false;
    }

    private ScheduledExecutorService startStreamingExecutor() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, r -> new Thread(r, "prefab-streaming-callback-executor"));
        return MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)((ScheduledThreadPoolExecutor)executor), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void startStreaming() {
        ScheduledExecutorService scheduledExecutorService = this.startStreamingExecutor();
        LOG.info("Starting SSE config subscriber");
        SseConfigStreamingSubscriber sseConfigStreamingSubscriber = new SseConfigStreamingSubscriber(this.prefabHttpClient, this.updatingConfigResolver::getHighwaterMark, configs -> this.loadConfigs((Prefab.Configs)configs, ConfigClient.Source.STREAMING), scheduledExecutorService);
        sseConfigStreamingSubscriber.start();
    }

    private void startCheckpointExecutor() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, r -> new Thread(r, "prefab-logger-checkpoint-executor"));
        ScheduledExecutorService scheduledExecutorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)((ScheduledThreadPoolExecutor)executor), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.loadCheckpoint();
            }
            catch (Exception e) {
                LOG.warn("Error getting checkpoint - will try again", (Throwable)e);
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    private void finishInit(ConfigClient.Source source) {
        List<ConfigChangeEvent> changes = this.updatingConfigResolver.update();
        this.broadcastChanges(changes);
        if (this.initializedLatch.getCount() > 0L) {
            this.initializedLatch.countDown();
            LOG.info("Initialized Prefab from {} at highwater {} with currently known configs\n {}", new Object[]{source, this.updatingConfigResolver.getHighwaterMark(), this.updatingConfigResolver.contentsString()});
        }
    }

    private synchronized void loadConfigs(Prefab.Configs configs, ConfigClient.Source source) {
        LOG.debug("Loading {} configs from {} pointer {}", new Object[]{configs.getConfigsCount(), source, configs.hasConfigServicePointer()});
        this.updatingConfigResolver.loadConfigs(configs, source);
        this.finishInit(source);
    }

    private void broadcastChanges(List<ConfigChangeEvent> changeEvents) {
        ArrayList<ConfigChangeListener> listeners = new ArrayList<ConfigChangeListener>(this.configChangeListeners);
        for (ConfigChangeListener listener : listeners) {
            for (ConfigChangeEvent changeEvent : changeEvents) {
                LOG.debug("Broadcasting change {} to {}", (Object)changeEvent, (Object)listener);
                listener.onChange(changeEvent);
            }
        }
    }

    private void waitForInitialization() {
        block3: {
            try {
                if (this.initializedLatch.await(this.options.getInitializationTimeoutSec(), TimeUnit.SECONDS)) break block3;
                if (this.options.getOnInitializationFailure() == Options.OnInitializationFailure.UNLOCK) {
                    this.finishInit(ConfigClient.Source.INIT_TIMEOUT);
                    break block3;
                }
                throw new PrefabInitializationTimeoutException(this.options.getInitializationTimeoutSec());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

