/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigStore;
import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.ConfigValueUtils;
import cloud.prefab.client.config.EvaluatedCriterion;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.internal.IntRangeWrapper;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.WeightedValueEvaluator;
import cloud.prefab.context.PrefabContext;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigResolver {
    public static final String NAMESPACE_KEY = "NAMESPACE";
    public static final String NEW_NAMESPACE_KEY = "prefab.namespace";
    public static final String CURRENT_TIME_KEY = "prefab.current-time";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResolver.class);
    private final ConfigStore configStore;
    private final WeightedValueEvaluator weightedValueEvaluator;
    private long projectEnvId = 0L;
    private AtomicReference<Map<String, Prefab.ConfigValue>> defaultContext = new AtomicReference(Collections.emptyMap());

    public ConfigResolver(ConfigStore configStoreImpl, WeightedValueEvaluator weightedValueEvaluator) {
        this(configStoreImpl, 0L, weightedValueEvaluator);
    }

    public ConfigResolver(ConfigStore configStoreImpl, long projectEnvId, WeightedValueEvaluator weightedValueEvaluator) {
        this.weightedValueEvaluator = weightedValueEvaluator;
        this.projectEnvId = projectEnvId;
        this.configStore = configStoreImpl;
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key) {
        return this.getConfigValue(key, LookupContext.EMPTY);
    }

    public Optional<Match> getMatch(String key, LookupContext lookupContext) {
        ConfigElement configElement = this.configStore.getElement(key);
        if (configElement == null) {
            if (!key.startsWith("log-level")) {
                LOG.trace("No config value found for key {}", (Object)key);
            }
            return Optional.empty();
        }
        return this.evalConfigElementMatch(configElement, lookupContext);
    }

    private Optional<Match> getMatch(String key, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        if (!this.configStore.containsKey(key)) {
            if (!key.startsWith("log-level")) {
                LOG.trace("No config value found for key {}", (Object)key);
            }
            return Optional.empty();
        }
        ConfigElement configElement = this.configStore.getElement(key);
        return this.evalConfigElementMatch(configElement, lookupContext, rowPropertiesStack);
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key, LookupContext lookupContext) {
        return this.getMatch(key, lookupContext).map(Match::getConfigValue);
    }

    public Map<String, Prefab.ConfigValue> getAllCurrentValues() {
        ImmutableMap.Builder allValues = ImmutableMap.builder();
        for (String key : this.getKeys()) {
            this.getConfigValue(key).ifPresent(configValue -> allValues.put((Object)key, configValue));
        }
        return allValues.buildKeepingLast();
    }

    private Optional<Match> evalConfigElementMatch(ConfigElement configElement, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        return Streams.mapWithIndex(configElement.getRowsProjEnvFirst(this.projectEnvId), (configRow, rowIndex) -> {
            if (!configRow.getPropertiesMap().isEmpty()) {
                rowPropertiesStack.push(configRow.getPropertiesMap());
            }
            int conditionalValueIndex = 0;
            for (Prefab.ConditionalValue conditionalValue : configRow.getValuesList()) {
                Optional<Match> optionalMatch = this.evaluateConditionalValue(rowIndex, conditionalValue, conditionalValueIndex, lookupContext, rowPropertiesStack, configElement);
                if (optionalMatch.isPresent()) {
                    return optionalMatch.get();
                }
                ++conditionalValueIndex;
            }
            if (!configRow.getPropertiesMap().isEmpty()) {
                rowPropertiesStack.pop();
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }

    Optional<Match> evalConfigElementMatch(ConfigElement configElement, LookupContext lookupContext) {
        return this.evalConfigElementMatch(configElement, lookupContext, new LinkedList<Map<String, Prefab.ConfigValue>>());
    }

    private Optional<Match> evaluateConditionalValue(long rowIndex, Prefab.ConditionalValue conditionalValue, int conditionalValueIndex, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowProperties, ConfigElement configElement) {
        ArrayList<EvaluatedCriterion> evaluatedCriteria = new ArrayList<EvaluatedCriterion>();
        for (Prefab.Criterion criterion : conditionalValue.getCriteriaList()) {
            for (EvaluatedCriterion evaluateCriterion : this.evaluateCriterionMatch(criterion, lookupContext, rowProperties)) {
                if (!evaluateCriterion.isMatch()) {
                    return Optional.empty();
                }
                evaluatedCriteria.add(evaluateCriterion);
            }
        }
        return Optional.of(this.simplifyToMatch(rowIndex, conditionalValue, conditionalValueIndex, configElement, lookupContext, evaluatedCriteria));
    }

    private Match simplifyToMatch(long rowIndex, Prefab.ConditionalValue selectedConditionalValue, int conditionalValueIndex, ConfigElement configElement, LookupContext lookupContext, List<EvaluatedCriterion> evaluatedCriteria) {
        if (selectedConditionalValue.getValue().hasWeightedValues()) {
            WeightedValueEvaluator.Result result = this.weightedValueEvaluator.toResult(selectedConditionalValue.getValue().getWeightedValues(), configElement.getConfig().getKey(), lookupContext);
            return new Match(result.getValue(), configElement, evaluatedCriteria, (int)rowIndex, conditionalValueIndex, Optional.of(result.getIndex()));
        }
        return new Match(selectedConditionalValue.getValue(), configElement, evaluatedCriteria, (int)rowIndex, conditionalValueIndex, Optional.empty());
    }

    private Optional<Prefab.ConfigValue> prop(String key, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        for (Map<String, Prefab.ConfigValue> rowProperties : rowPropertiesStack) {
            if (!rowProperties.containsKey(key)) continue;
            return Optional.of(rowProperties.get(key));
        }
        Prefab.ConfigValue configFromDefaultContext = this.defaultContext.get().get(key);
        if (configFromDefaultContext != null) {
            return Optional.of(configFromDefaultContext);
        }
        Prefab.ConfigValue valueFromLookupContext = lookupContext.getExpandedProperties().get(key);
        if (valueFromLookupContext != null) {
            return Optional.of(valueFromLookupContext);
        }
        if (CURRENT_TIME_KEY.equals(key)) {
            return Optional.of(Prefab.ConfigValue.newBuilder().setInt(System.currentTimeMillis()).build());
        }
        return Optional.empty();
    }

    List<EvaluatedCriterion> evaluateCriterionMatch(Prefab.Criterion criterion, LookupContext lookupContext) {
        return this.evaluateCriterionMatch(criterion, lookupContext, new LinkedList<Map<String, Prefab.ConfigValue>>());
    }

    List<EvaluatedCriterion> evaluateCriterionMatch(Prefab.Criterion criterion, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        Optional<Prefab.ConfigValue> prop = this.prop(criterion.getPropertyName(), lookupContext, rowPropertiesStack);
        Optional propStringValue = prop.flatMap(ConfigValueUtils::coerceToString);
        switch (criterion.getOperator()) {
            case ALWAYS_TRUE: {
                return List.of(new EvaluatedCriterion(criterion, true));
            }
            case HIERARCHICAL_MATCH: {
                if (prop.isPresent() && prop.get().hasString() && criterion.getValueToMatch().hasString()) {
                    String propertyString = prop.get().getString();
                    return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), this.hierarchicalMatch(propertyString, criterion.getValueToMatch().getString())));
                }
                return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), false));
            }
            case IN_SEG: {
                Optional<Match> evaluatedSegment = this.getMatch(criterion.getValueToMatch().getString(), lookupContext, rowPropertiesStack);
                if (evaluatedSegment.isPresent() && evaluatedSegment.get().getConfigValue().hasBool() && evaluatedSegment.get().getConfigValue().getBool()) {
                    return evaluatedSegment.get().getEvaluatedCriterion();
                }
                return List.of(new EvaluatedCriterion(criterion, "Missing Segment " + criterion.getValueToMatch().getString(), false));
            }
            case NOT_IN_SEG: {
                Optional<Prefab.ConfigValue> evaluatedNotSegment = this.getConfigValue(criterion.getValueToMatch().getString(), lookupContext);
                if (evaluatedNotSegment.isPresent() && evaluatedNotSegment.get().hasBool()) {
                    return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), !evaluatedNotSegment.get().getBool()));
                }
                return List.of(new EvaluatedCriterion(criterion, "Missing Segment " + criterion.getValueToMatch().getString(), true));
            }
            case PROP_IS_ONE_OF: {
                if (propStringValue.isEmpty()) {
                    return List.of(new EvaluatedCriterion(criterion, false));
                }
                return List.of(new EvaluatedCriterion(criterion, (String)propStringValue.get(), criterion.getValueToMatch().getStringList().getValuesList().contains(propStringValue.get())));
            }
            case PROP_IS_NOT_ONE_OF: {
                if (propStringValue.isEmpty()) {
                    return List.of(new EvaluatedCriterion(criterion, false));
                }
                return List.of(new EvaluatedCriterion(criterion, (String)propStringValue.get(), !criterion.getValueToMatch().getStringList().getValuesList().contains(propStringValue.get())));
            }
            case PROP_ENDS_WITH_ONE_OF: {
                if (prop.isPresent() && prop.get().hasString()) {
                    boolean matched = criterion.getValueToMatch().getStringList().getValuesList().stream().anyMatch(value -> ((Prefab.ConfigValue)prop.get()).getString().endsWith((String)value));
                    return List.of(new EvaluatedCriterion(criterion, prop.get(), matched));
                }
                return List.of(new EvaluatedCriterion(criterion, false));
            }
            case PROP_DOES_NOT_END_WITH_ONE_OF: {
                if (prop.isPresent() && prop.get().hasString()) {
                    boolean matched;
                    return List.of(new EvaluatedCriterion(criterion, prop.get(), !(matched = criterion.getValueToMatch().getStringList().getValuesList().stream().anyMatch(value -> ((Prefab.ConfigValue)prop.get()).getString().endsWith((String)value)))));
                }
                return List.of(new EvaluatedCriterion(criterion, true));
            }
            case IN_INT_RANGE: {
                if (!prop.isPresent() || !prop.get().hasInt() || !criterion.getValueToMatch().hasIntRange()) break;
                return List.of(new EvaluatedCriterion(criterion, IntRangeWrapper.of(criterion.getValueToMatch().getIntRange()).contains(prop.get().getInt())));
            }
        }
        LOG.debug("Unexpected operator {} found in criterion {}", (Object)criterion.getOperator(), (Object)criterion);
        return List.of(new EvaluatedCriterion(criterion, false));
    }

    boolean hierarchicalMatch(String propertyString, String valueToMatch) {
        return propertyString.startsWith(valueToMatch);
    }

    public boolean setProjectEnvId(Prefab.Configs configs) {
        if (configs.hasConfigServicePointer()) {
            this.projectEnvId = configs.getConfigServicePointer().getProjectEnvId();
            return true;
        }
        return false;
    }

    public void setDefaultContext(Prefab.Configs configs) {
        if (configs.getDefaultContext().getContextsCount() == 0) {
            this.defaultContext.set(Collections.emptyMap());
        }
        HashMap mergedMap = new HashMap();
        configs.getDefaultContext().getContextsList().forEach(c -> mergedMap.putAll(PrefabContext.fromProto(c).getNameQualifiedProperties()));
        this.defaultContext.set(mergedMap);
    }

    public Collection<String> getKeys() {
        return this.configStore.getKeys();
    }

    public Collection<String> getKeysOfConfigType(Prefab.ConfigType configType) {
        return this.configStore.getElements().stream().map(ConfigElement::getConfig).filter(config -> config.getConfigType() == configType).map(Prefab.Config::getKey).collect(Collectors.toList());
    }

    public ConfigElement getRaw(String key) {
        return this.configStore.getElement(key);
    }

    public boolean containsKey(String key) {
        return this.configStore.containsKey(key);
    }

    public String contentsString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> sortedKeys = new ArrayList<String>(this.getKeys());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            ConfigElement configElement = this.configStore.getElement(key);
            Optional<Match> match = this.evalConfigElementMatch(configElement, LookupContext.EMPTY);
            if (!match.isPresent()) continue;
            sb.append(this.padded(key, 45));
            sb.append(this.padded(this.toS(match.get().getConfigValue()), 40));
            sb.append(this.padded(configElement.getProvenance().toString(), 40));
            sb.append(this.padded(match.get().getReason(), 40));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toS(Prefab.ConfigValue configValue) {
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.STRING) {
            return configValue.getString();
        }
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.INT) {
            return Long.toString(configValue.getInt());
        }
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.BOOL) {
            return Boolean.toString(configValue.getBool());
        }
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.BYTES) {
            return "Bytes";
        }
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.DOUBLE) {
            return Double.toString(configValue.getDouble());
        }
        if (configValue.getTypeCase() == Prefab.ConfigValue.TypeCase.LOG_LEVEL) {
            return configValue.getLogLevel().toString();
        }
        return "Unknown";
    }

    private String padded(String s, int size) {
        return String.format("%-" + size + "s", s.substring(0, Math.min(s.length(), size - 1)));
    }
}

