/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.config.ConfigChangeEvent;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigStoreDeltaCalculator {
    public List<ConfigChangeEvent> computeChangeEvents(Map<String, Optional<Prefab.ConfigValue>> before, Map<String, Optional<Prefab.ConfigValue>> after) {
        MapDifference delta = Maps.difference(before, after);
        if (delta.areEqual()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder changeEvents = ImmutableList.builder();
        delta.entriesOnlyOnLeft().forEach((key, value) -> changeEvents.add((Object)new ConfigChangeEvent((String)key, (Optional<Prefab.ConfigValue>)value, Optional.empty())));
        delta.entriesOnlyOnRight().forEach((key, value) -> changeEvents.add((Object)new ConfigChangeEvent((String)key, Optional.empty(), (Optional<Prefab.ConfigValue>)value)));
        delta.entriesDiffering().forEach((key, values) -> changeEvents.add((Object)new ConfigChangeEvent((String)key, (Optional)values.leftValue(), (Optional)values.rightValue())));
        return changeEvents.build();
    }
}

