/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.config.ConfigChangeEvent;
import cloud.prefab.client.config.ConfigChangeListener;
import cloud.prefab.domain.Prefab;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingConfigListener
implements ConfigChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConfigListener.class);
    private final Supplier<Boolean> systemInitializedSupplier;

    LoggingConfigListener(Supplier<Boolean> systemInitializedSupplier) {
        this.systemInitializedSupplier = systemInitializedSupplier;
    }

    @Override
    public void onChange(ConfigChangeEvent changeEvent) {
        if (this.systemInitializedSupplier.get().booleanValue()) {
            if (changeEvent.getNewValue().isEmpty()) {
                LOG.info("Config value '{}' removed. Previous value was '{}'", (Object)changeEvent.getKey(), (Object)LoggingConfigListener.toJson(changeEvent.getOldValue().get()));
            } else if (changeEvent.getOldValue().isEmpty()) {
                LOG.info("Config value '{}' added. New value is '{}'", (Object)changeEvent.getKey(), (Object)LoggingConfigListener.toJson(changeEvent.getNewValue().get()));
            } else {
                LOG.info("Config value '{}' updated. Previous value was '{}', new value is '{}'", new Object[]{changeEvent.getKey(), LoggingConfigListener.toJson(changeEvent.getOldValue().get()), LoggingConfigListener.toJson(changeEvent.getNewValue().get())});
            }
        } else {
            LOG.debug("Not logging config change event {} before system initialization", (Object)changeEvent);
        }
    }

    private static String toJson(Prefab.ConfigValue configValue) {
        try {
            return JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)configValue);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Error writing config value to json", e);
        }
    }
}

