/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class LookupContext {
    public static final LookupContext EMPTY = new LookupContext(Optional.empty(), PrefabContextSetReadable.EMPTY);
    private final Optional<Prefab.ConfigValue> namespaceMaybe;
    private final PrefabContextSet prefabContextSet;
    private Map<String, Prefab.ConfigValue> expandedProperties = null;

    public LookupContext(Optional<Prefab.ConfigValue> namespace, PrefabContextSetReadable prefabContextSetReadable) {
        this.namespaceMaybe = namespace;
        this.prefabContextSet = PrefabContextSet.convert(prefabContextSetReadable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupContext that = (LookupContext)o;
        return Objects.equals(this.namespaceMaybe, that.namespaceMaybe) && Objects.equals(this.prefabContextSet, that.prefabContextSet);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceMaybe, this.prefabContextSet);
    }

    public Optional<Prefab.ConfigValue> getNamespace() {
        return this.namespaceMaybe;
    }

    public Optional<Prefab.ConfigValue> getValue(String name) {
        return Optional.ofNullable(this.getExpandedProperties().get(name));
    }

    public PrefabContextSet getPrefabContextSet() {
        return this.prefabContextSet;
    }

    public Map<String, Prefab.ConfigValue> getExpandedProperties() {
        if (this.expandedProperties == null) {
            int propertyCount = StreamSupport.stream(this.prefabContextSet.getContexts().spliterator(), false).mapToInt(context -> context.getProperties().size()).sum() + 1;
            HashMap expandedProperties = Maps.newHashMapWithExpectedSize((int)propertyCount);
            for (PrefabContext context2 : this.prefabContextSet.getContexts()) {
                String prefix = context2.getName().isBlank() ? "" : context2.getName().toLowerCase() + ".";
                for (Map.Entry<String, Prefab.ConfigValue> stringConfigValueEntry : context2.getProperties().entrySet()) {
                    expandedProperties.put(prefix + stringConfigValueEntry.getKey(), stringConfigValueEntry.getValue());
                }
            }
            this.namespaceMaybe.ifPresent(namespace -> {
                expandedProperties.put("NAMESPACE", namespace);
                expandedProperties.put("prefab.namespace", namespace);
            });
            this.expandedProperties = ImmutableMap.copyOf((Map)expandedProperties);
        }
        return this.expandedProperties;
    }
}

