/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.config.Match;
import cloud.prefab.domain.Prefab;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MatchStatsAggregator {
    private static final Set<Prefab.ConfigType> SUPPORTED_CONFIG_TYPES = Sets.immutableEnumSet((Enum)Prefab.ConfigType.CONFIG, (Enum[])new Prefab.ConfigType[]{Prefab.ConfigType.FEATURE_FLAG});
    private StatsAggregate statsAggregate = new StatsAggregate();

    void setStatsAggregate(StatsAggregate statsAggregate) {
        this.statsAggregate = statsAggregate;
    }

    StatsAggregate getStatsAggregate() {
        return this.statsAggregate;
    }

    StatsAggregate getAndResetStatsAggregate() {
        StatsAggregate currentStatsAggregate = this.statsAggregate;
        this.statsAggregate = new StatsAggregate();
        return currentStatsAggregate;
    }

    void recordMatch(Match match, long timeStamp) {
        if (SUPPORTED_CONFIG_TYPES.contains((Object)match.getConfigElement().getConfig().getConfigType())) {
            this.statsAggregate.recordMatch(match, timeStamp);
        }
    }

    static class StatsAggregate {
        Map<ConfigKeyAndTypeKey, Map<CountKey, Counter>> counterData = new HashMap<ConfigKeyAndTypeKey, Map<CountKey, Counter>>();
        long minTime = 0L;
        long maxTime = 0L;

        StatsAggregate() {
        }

        long getMinTime() {
            return this.minTime;
        }

        long getMaxTime() {
            return this.maxTime;
        }

        Map<ConfigKeyAndTypeKey, Map<CountKey, Counter>> getCounterData() {
            return this.counterData;
        }

        void recordMatch(Match match, long timeStamp) {
            if (this.minTime == 0L || timeStamp < this.minTime) {
                this.minTime = timeStamp;
            }
            if (timeStamp > this.maxTime) {
                this.maxTime = timeStamp;
            }
            ConfigKeyAndTypeKey configKeyAndTypeKey = new ConfigKeyAndTypeKey(match.getConfigElement().getConfig().getKey(), match.getConfigElement().getConfig().getConfigType());
            Map innerMap = this.counterData.computeIfAbsent(configKeyAndTypeKey, ignored -> new HashMap());
            CountKey countKey = new CountKey(match.getConfigElement().getConfig().getId(), match.getConfigValue(), this.indexOfMatch(match.getConfigValue(), match.getConfigElement().getConfig().getAllowableValuesList()), match.getRowIndex(), match.getConditionalValueIndex(), match.getWeightedValueIndex());
            innerMap.computeIfAbsent(countKey, c -> new Counter(0L)).inc();
        }

        private int indexOfMatch(Prefab.ConfigValue configValue, List<Prefab.ConfigValue> allowableValuesList) {
            int selectedIndex = 0;
            for (Prefab.ConfigValue value : allowableValuesList) {
                if (value.equals(configValue)) {
                    return selectedIndex;
                }
                ++selectedIndex;
            }
            return -1;
        }

        Prefab.ConfigEvaluationSummaries toProto() {
            Prefab.ConfigEvaluationSummaries.Builder builder = Prefab.ConfigEvaluationSummaries.newBuilder();
            builder.setStart(this.getMinTime());
            builder.setEnd(this.getMaxTime());
            for (Map.Entry<ConfigKeyAndTypeKey, Map<CountKey, Counter>> mapEntry : this.counterData.entrySet()) {
                Prefab.ConfigEvaluationSummary.Builder summaryBuilder = Prefab.ConfigEvaluationSummary.newBuilder().setType(mapEntry.getKey().configType).setKey(mapEntry.getKey().key);
                for (Map.Entry<CountKey, Counter> countKeyCounterEntry : mapEntry.getValue().entrySet()) {
                    CountKey countKey = countKeyCounterEntry.getKey();
                    Counter counter = countKeyCounterEntry.getValue();
                    Prefab.ConfigEvaluationCounter.Builder counterProtoBuilder = Prefab.ConfigEvaluationCounter.newBuilder().setConfigId(countKey.configId).setCount(counter.count);
                    if (countKey.selectedIndex >= 0) {
                        counterProtoBuilder.setSelectedIndex(countKey.selectedIndex);
                    }
                    counterProtoBuilder.setConfigRowIndex(countKey.rowIndex);
                    counterProtoBuilder.setConditionalValueIndex(countKey.valueIndex);
                    countKey.weightedValueIndex.ifPresent(counterProtoBuilder::setWeightedValueIndex);
                    counterProtoBuilder.setSelectedValue(countKey.configValue);
                    summaryBuilder.addCounters(counterProtoBuilder);
                }
                builder.addSummaries(summaryBuilder.build());
            }
            return builder.build();
        }
    }

    static class Counter {
        long count;

        void inc() {
            ++this.count;
        }

        Counter() {
            this(0L);
        }

        Counter(long count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Counter counter = (Counter)o;
            return this.count == counter.count;
        }

        public int hashCode() {
            return Objects.hash(this.count);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).toString();
        }
    }

    static class CountKey {
        final long configId;
        final int selectedIndex;
        private final int rowIndex;
        private final int valueIndex;
        private final Optional<Integer> weightedValueIndex;
        final Prefab.ConfigValue configValue;

        CountKey(long configId, Prefab.ConfigValue configValue, int selectedIndex, int rowIndex, int valueIndex, Optional<Integer> weightedValueIndex) {
            this.configId = configId;
            this.selectedIndex = selectedIndex;
            this.rowIndex = rowIndex;
            this.valueIndex = valueIndex;
            this.weightedValueIndex = weightedValueIndex;
            this.configValue = configValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountKey countKey = (CountKey)o;
            return this.configId == countKey.configId && this.selectedIndex == countKey.selectedIndex && this.rowIndex == countKey.rowIndex && this.valueIndex == countKey.valueIndex && Objects.equals(this.weightedValueIndex, countKey.weightedValueIndex) && Objects.equals(this.configValue, countKey.configValue);
        }

        public int hashCode() {
            return Objects.hash(this.configId, this.selectedIndex, this.rowIndex, this.valueIndex, this.weightedValueIndex, this.configValue);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("configId", this.configId).add("selectedIndex", this.selectedIndex).add("rowIndex", this.rowIndex).add("valueIndex", this.valueIndex).add("weightedValueIndex", this.weightedValueIndex).add("configValue", (Object)this.configValue).toString();
        }
    }

    static class ConfigKeyAndTypeKey {
        final String key;
        final Prefab.ConfigType configType;

        public ConfigKeyAndTypeKey(String key, Prefab.ConfigType configType) {
            this.key = key;
            this.configType = configType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigKeyAndTypeKey that = (ConfigKeyAndTypeKey)o;
            return Objects.equals(this.key, that.key) && this.configType == that.configType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.configType});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("configType", (Object)this.configType).toString();
        }
    }
}

