/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.Options;
import cloud.prefab.client.util.MavenInfo;
import cloud.prefab.domain.Prefab;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefabHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(PrefabHttpClient.class);
    public static final String CLIENT_HEADER_KEY = "client";
    private static final String VERSION_HEADER = "X-PrefabCloud-Client-Version";
    public static final String CLIENT_HEADER_VALUE = String.format("%s.%s", MavenInfo.getInstance().getArtifactId(), MavenInfo.getInstance().getVersion());
    public static final String NEW_CLIENT_HEADER_VALUE = "prefab-cloud-java-" + MavenInfo.getInstance().getVersion();
    private static final String PROTO_MEDIA_TYPE = "application/x-protobuf";
    private static final String EVENT_STREAM_MEDIA_TYPE = "text/event-stream";
    private static final String START_AT_HEADER = "x-prefab-start-at-id";
    private final Options options;
    private final HttpClient httpClient;

    PrefabHttpClient(HttpClient httpClient, Options options) {
        this.httpClient = httpClient;
        this.options = options;
    }

    void reportLoggers(Prefab.Loggers loggers) {
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Content-Type", PROTO_MEDIA_TYPE).header("Accept", PROTO_MEDIA_TYPE).uri(URI.create(this.options.getPrefabApiUrl() + "/api/v1/known-loggers")).POST(HttpRequest.BodyPublishers.ofByteArray(loggers.toByteArray())).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (!PrefabHttpClient.isSuccess(response.statusCode())) {
                LOG.info("Uploading logger stats returned unsuccessful code {} with body {}", (Object)response.statusCode(), (Object)response.body());
            }
        }
        catch (IOException e) {
            LOG.warn("Error uploading logger stats via http {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while uploading logger stats via http");
            Thread.currentThread().interrupt();
        }
    }

    private static HttpResponse.BodySubscriber<Supplier<Prefab.TelemetryEventsResponse>> asProto() {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return HttpResponse.BodySubscribers.mapping(upstream, inputStream -> () -> {
            Prefab.TelemetryEventsResponse telemetryEventsResponse;
            block8: {
                InputStream stream = inputStream;
                try {
                    telemetryEventsResponse = Prefab.TelemetryEventsResponse.parseFrom(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                stream.close();
            }
            return telemetryEventsResponse;
        });
    }

    CompletableFuture<HttpResponse<Supplier<Prefab.TelemetryEventsResponse>>> reportTelemetryEvents(Prefab.TelemetryEvents telemetryEvents) {
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Content-Type", PROTO_MEDIA_TYPE).header("Accept", PROTO_MEDIA_TYPE).uri(URI.create(this.options.getPrefabApiUrl() + "/api/v1/telemetry")).POST(HttpRequest.BodyPublishers.ofByteArray(telemetryEvents.toByteArray())).build();
        return this.httpClient.sendAsync(request, responseInfo -> PrefabHttpClient.asProto());
    }

    boolean reportContextShape(Prefab.ContextShapes contextShapes) {
        if (contextShapes.getShapesList().isEmpty()) {
            return true;
        }
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Content-Type", PROTO_MEDIA_TYPE).header("Accept", PROTO_MEDIA_TYPE).uri(URI.create(this.options.getPrefabApiUrl() + "/api/v1/context-shapes")).POST(HttpRequest.BodyPublishers.ofByteArray(contextShapes.toByteArray())).build();
        LOG.debug("posting context shape to {}", (Object)request.uri());
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (PrefabHttpClient.isSuccess(response.statusCode())) {
                return true;
            }
            LOG.info("Uploading context shapes returned unsuccessful code {} with body {}", (Object)response.statusCode(), (Object)response.body());
        }
        catch (IOException e) {
            LOG.warn("Error uploading context shapes via http {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while uploading context shapes");
            Thread.currentThread().interrupt();
        }
        return false;
    }

    boolean reportEvaluatedKeys(Prefab.EvaluatedKeys evaluatedKeys) {
        if (evaluatedKeys.getKeysList().isEmpty()) {
            return true;
        }
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Content-Type", PROTO_MEDIA_TYPE).header("Accept", PROTO_MEDIA_TYPE).uri(URI.create(this.options.getPrefabApiUrl() + "/api/v1/evaluated-keys")).POST(HttpRequest.BodyPublishers.ofByteArray(evaluatedKeys.toByteArray())).build();
        LOG.debug("posting evaluated keys to {}", (Object)request.uri());
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (PrefabHttpClient.isSuccess(response.statusCode())) {
                return true;
            }
            LOG.info("Uploading evaluated keys returned unsuccessful code {} with body {}", (Object)response.statusCode(), (Object)response.body());
        }
        catch (IOException e) {
            LOG.warn("Error uploading evaluated keys via http {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while uploading evaluated keys");
            Thread.currentThread().interrupt();
        }
        return false;
    }

    CompletableFuture<HttpResponse<Void>> requestConfigSSE(long offset, Flow.Subscriber<String> lineSubscriber) {
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Accept", EVENT_STREAM_MEDIA_TYPE).header(START_AT_HEADER, String.valueOf(offset)).timeout(Duration.ofSeconds(5L)).uri(URI.create(this.options.getPrefabApiUrl() + "/api/v1/sse/config")).build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.fromLineSubscriber(lineSubscriber));
    }

    CompletableFuture<HttpResponse<Supplier<Prefab.Configs>>> requestConfigsFromApi(long offset) {
        return this.requestConfigsFromURI(URI.create(this.options.getPrefabApiUrl() + "/api/v1/configs/" + offset));
    }

    CompletableFuture<HttpResponse<Supplier<Prefab.Configs>>> requestConfigsFromCDN(long offset) {
        return this.requestConfigsFromURI(URI.create(this.options.getCDNUrl() + "/api/v1/configs/" + offset));
    }

    private CompletableFuture<HttpResponse<Supplier<Prefab.Configs>>> requestConfigsFromURI(URI uri) {
        HttpRequest request = this.getClientBuilderWithStandardHeaders().header("Accept", PROTO_MEDIA_TYPE).timeout(Duration.ofSeconds(5L)).uri(uri).build();
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        HttpResponse.BodySubscriber<Supplier> mapper = HttpResponse.BodySubscribers.mapping(upstream, this::configsSupplier);
        return this.httpClient.sendAsync(request, resp -> mapper);
    }

    private Supplier<Prefab.Configs> configsSupplier(InputStream inputStream) {
        return () -> {
            try {
                return Prefab.Configs.parseFrom(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private HttpRequest.Builder getClientBuilderWithStandardHeaders() {
        return HttpRequest.newBuilder().header(CLIENT_HEADER_KEY, CLIENT_HEADER_VALUE).header(VERSION_HEADER, NEW_CLIENT_HEADER_VALUE).header("Authorization", this.getBasicAuthenticationHeader(this.options.getApiKeyId(), this.options.getApikey()));
    }

    static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public static class BadStatusCodeException
    extends Exception {
        int statusCode;

        BadStatusCodeException(int statusCode) {
            this.statusCode = statusCode;
        }
    }
}

