/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.Options;
import cloud.prefab.client.internal.PrefabHttpClient;
import cloud.prefab.client.internal.TelemetryManager;
import cloud.prefab.domain.Prefab;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dev.failsafe.Bulkhead;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.net.http.HttpResponse;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryUploader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryUploader.class);
    private final LinkedBlockingQueue<TelemetryManager.OutputBuffer> queue;
    private final Options options;
    private final PrefabHttpClient prefabHttpClient;
    private final Bulkhead<HttpResponse<Supplier<Prefab.TelemetryEventsResponse>>> bulkhead = Bulkhead.builder((int)5).build();
    private final RetryPolicy<HttpResponse<Supplier<Prefab.TelemetryEventsResponse>>> retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().withMaxRetries(3).withBackoff(1L, 10L, ChronoUnit.SECONDS).handleResultIf(r -> RETRYABLE_STATUS_CODES.contains(r.statusCode()))).build();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread uploaderThread;
    private static final Set<Integer> RETRYABLE_STATUS_CODES = Set.of(Integer.valueOf(429), Integer.valueOf(500), Integer.valueOf(503));

    TelemetryUploader(LinkedBlockingQueue<TelemetryManager.OutputBuffer> queue, PrefabHttpClient prefabHttpClient, Options options) {
        this.prefabHttpClient = prefabHttpClient;
        this.queue = queue;
        this.options = options;
    }

    void start() {
        if (this.queue == null) {
            throw new IllegalStateException("Queue is null");
        }
        if (this.running.compareAndSet(false, true)) {
            ThreadFactory uploaderFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefab-telemetry-uploader-%d").build();
            this.uploaderThread = uploaderFactory.newThread(this::uploadLoop);
            this.uploaderThread.setUncaughtExceptionHandler((t, e) -> LOG.error("uncaught exception in thread t {}", (Object)t.getName(), (Object)e));
            this.uploaderThread.setDaemon(true);
            this.uploaderThread.start();
        }
    }

    void uploadLoop() {
        do {
            try {
                this.bulkhead.acquirePermit();
                TelemetryManager.OutputBuffer outputBuffer = this.queue.take();
                Prefab.TelemetryEvents telemetryEvents = outputBuffer.toTelemetryEvents();
                if (!telemetryEvents.getEventsList().isEmpty()) {
                    LOG.debug("Uploading {}", (Object)telemetryEvents);
                    Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).getStageAsync(() -> this.prefabHttpClient.reportTelemetryEvents(telemetryEvents)).whenComplete((r, t) -> {
                        outputBuffer.complete();
                        this.options.getTelemetryListener().ifPresent(telemetryListener -> {
                            if (r != null && r.statusCode() >= 200 && r.statusCode() < 300) {
                                telemetryListener.telemetryUpload(telemetryEvents);
                            }
                        });
                        this.bulkhead.releasePermit();
                    });
                    continue;
                }
                outputBuffer.complete();
                this.bulkhead.releasePermit();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.running.get());
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false) && this.uploaderThread != null) {
            this.uploaderThread.interrupt();
        }
    }
}

