/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.config.ConfigChangeEvent;
import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.config.Provenance;
import cloud.prefab.client.internal.ConfigLoader;
import cloud.prefab.client.internal.ConfigResolver;
import cloud.prefab.client.internal.ConfigStoreDeltaCalculator;
import cloud.prefab.client.internal.ConfigStoreImpl;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.WeightedValueEvaluator;
import cloud.prefab.domain.Prefab;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatingConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatingConfigResolver.class);
    private final ConfigLoader configLoader;
    private final ConfigStoreDeltaCalculator configStoreDeltaCalculator;
    private final ConfigStoreImpl configStore;
    private ConfigResolver configResolver;

    public UpdatingConfigResolver(ConfigLoader configLoader, WeightedValueEvaluator weightedValueEvaluator, ConfigStoreDeltaCalculator configStoreDeltaCalculator) {
        this.configLoader = configLoader;
        this.configStoreDeltaCalculator = configStoreDeltaCalculator;
        this.configStore = new ConfigStoreImpl();
        this.configResolver = new ConfigResolver(this.configStore, weightedValueEvaluator);
    }

    public List<ConfigChangeEvent> update() {
        Map<String, Optional<Prefab.ConfigValue>> before = this.configStore.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.configResolver.getConfigValue((String)e.getKey())));
        this.makeLocal();
        Map<String, Optional<Prefab.ConfigValue>> after = this.configStore.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.configResolver.getConfigValue((String)e.getKey())));
        return this.configStoreDeltaCalculator.computeChangeEvents(before, after);
    }

    public long getHighwaterMark() {
        return this.configLoader.getHighwaterMark();
    }

    public synchronized void loadConfigsFromLocalFile() {
        this.loadConfigs(this.configLoader.loadFromJsonFile(), ConfigClient.Source.LOCAL_FILE);
    }

    public synchronized void loadConfigs(Prefab.Configs configs, ConfigClient.Source source) {
        this.setProjectEnvId(configs);
        this.configResolver.setDefaultContext(configs);
        long startingHighWaterMark = this.configLoader.getHighwaterMark();
        Provenance provenance = new Provenance(source);
        this.configLoader.setConfigs(configs, provenance);
        if (this.configLoader.getHighwaterMark() > startingHighWaterMark) {
            LOG.info("Found new checkpoint with highwater id {} from {} in project {} environment: {} with {} configs", new Object[]{this.configLoader.getHighwaterMark(), provenance, configs.getConfigServicePointer().getProjectId(), configs.getConfigServicePointer().getProjectEnvId(), configs.getConfigsCount()});
        } else {
            LOG.debug("Checkpoint with highwater with highwater id {} from {}. No changes.", (Object)this.configLoader.getHighwaterMark(), (Object)provenance.getSource());
        }
    }

    private void makeLocal() {
        ImmutableMap.Builder store = ImmutableMap.builder();
        this.configLoader.calcConfig().forEach((key, configElement) -> store.put(key, configElement));
        this.configStore.set((ImmutableMap<String, ConfigElement>)store.buildKeepingLast());
    }

    public String contentsString() {
        return this.configResolver.contentsString();
    }

    public boolean setProjectEnvId(Prefab.Configs configs) {
        return this.configResolver.setProjectEnvId(configs);
    }

    public Collection<String> getKeys() {
        return this.configResolver.getKeys();
    }

    public boolean containsKey(String key) {
        return this.configResolver.containsKey(key);
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key, LookupContext lookupContext) {
        return this.configResolver.getConfigValue(key, lookupContext);
    }

    public Optional<Prefab.ConfigValue> getConfigValue(String key) {
        return this.configResolver.getConfigValue(key);
    }

    public ConfigResolver getResolver() {
        return this.configResolver;
    }

    public Optional<Match> getMatch(String key, LookupContext lookupContext) {
        return this.configResolver.getMatch(key, lookupContext);
    }
}

