/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.value;

import cloud.prefab.client.value.Value;
import java.util.Optional;
import java.util.function.Supplier;

public class FixedValue<T>
implements Value<T> {
    private final Optional<T> value;

    public FixedValue() {
        this.value = Optional.empty();
    }

    public FixedValue(T value) {
        this.value = Optional.of(value);
    }

    @Override
    public T get() {
        if (this.value.isPresent()) {
            return this.value.get();
        }
        throw new RuntimeException("Fixed Value Unset");
    }

    @Override
    public Optional<T> getMaybe() {
        return this.value;
    }

    @Override
    public T orElse(T defaultValue) {
        return this.value.orElse(defaultValue);
    }

    @Override
    public T orElseGet(Supplier<T> defaultValueSupplier) {
        return this.value.orElseGet(defaultValueSupplier);
    }

    @Override
    public T orNull() {
        return this.value.orElse(null);
    }

    public static <T> FixedValue<T> of(T value) {
        return new FixedValue<T>(value);
    }

    public static <T> FixedValue<T> empty() {
        return new FixedValue<T>();
    }

    public String toString() {
        return String.format("FixedValue{}=%s", this.orNull());
    }
}

