/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.context.ContextStore;
import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSetReadable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CompositeContextStore
implements ContextStore {
    private final List<ContextStore> contextStores;

    public CompositeContextStore(ContextStore ... contextStores) {
        this.contextStores = Arrays.asList(contextStores);
    }

    @Override
    public void addContext(PrefabContext prefabContext) {
        this.getValidStore().ifPresent(cs -> cs.addContext(prefabContext));
    }

    @Override
    public Optional<PrefabContextSetReadable> setContext(PrefabContextSetReadable prefabContextSetReadable) {
        return this.getValidStore().flatMap(cs -> cs.setContext(prefabContextSetReadable));
    }

    @Override
    public Optional<PrefabContextSetReadable> clearContext() {
        return this.getValidStore().flatMap(ContextStore::clearContext);
    }

    @Override
    public Optional<PrefabContextSetReadable> getContext() {
        return this.getValidStore().flatMap(ContextStore::getContext);
    }

    Optional<ContextStore> getValidStore() {
        return this.contextStores.stream().filter(ContextStore::isAvailable).findFirst();
    }
}

