/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.client.config.ConfigValueUtils;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PrefabContext
implements PrefabContextSetReadable {
    private final String name;
    private final Map<String, Prefab.ConfigValue> properties;

    private PrefabContext(String name, Map<String, Prefab.ConfigValue> properties) {
        this.name = name;
        this.properties = Map.copyOf(properties);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Map<String, Prefab.ConfigValue> getProperties() {
        return this.properties;
    }

    public Map<String, Prefab.ConfigValue> getNameQualifiedProperties() {
        if (this.name.isBlank()) {
            return this.getProperties();
        }
        String prefix = this.getName().toLowerCase() + ".";
        return this.properties.entrySet().stream().map(entry -> Map.entry(prefix + (String)entry.getKey(), (Prefab.ConfigValue)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<PrefabContext> getByName(String contextType) {
        if (contextType.equals(this.name)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<PrefabContext> getContexts() {
        return Collections.singleton(this);
    }

    public Prefab.Context toProtoContext() {
        return Prefab.Context.newBuilder().setType(this.getName()).putAllValues(this.getProperties()).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefabContext that = (PrefabContext)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("properties", this.properties).toString();
    }

    public Prefab.ContextShape getShape() {
        Prefab.ContextShape.Builder shapeBuilder = Prefab.ContextShape.newBuilder().setName(this.getName());
        this.properties.forEach((key, value) -> shapeBuilder.putFieldTypes((String)key, value.getTypeCase().getNumber()));
        return shapeBuilder.build();
    }

    public static PrefabContext unnamedFromMap(Map<String, Prefab.ConfigValue> configValueMap) {
        return new PrefabContext("", configValueMap);
    }

    public static PrefabContext fromMap(String name, Map<String, Prefab.ConfigValue> configValueMap) {
        return new PrefabContext(name, configValueMap);
    }

    public static PrefabContext fromProto(Prefab.Context protoContext) {
        return new PrefabContext(protoContext.getType(), protoContext.getValuesMap());
    }

    public static Builder newBuilder(String contextType) {
        return new Builder(contextType);
    }

    public static class Builder {
        private final String contextType;
        private final Map<String, Prefab.ConfigValue> properties = new HashMap<String, Prefab.ConfigValue>();

        private Builder(String contextType) {
            this.contextType = contextType;
        }

        public Builder put(String propertyName, String value) {
            return this.put(propertyName, ConfigValueUtils.from(value));
        }

        public Builder put(String propertyName, boolean value) {
            return this.put(propertyName, ConfigValueUtils.from(value));
        }

        public Builder put(String propertyName, long value) {
            return this.put(propertyName, ConfigValueUtils.from(value));
        }

        public Builder put(String propertyName, double value) {
            return this.put(propertyName, ConfigValueUtils.from(value));
        }

        public Builder put(String propertyName, List<String> value) {
            return this.put(propertyName, ConfigValueUtils.from(value));
        }

        public Builder put(String propertyName, Prefab.ConfigValue configValue) {
            this.properties.put(propertyName, configValue);
            return this;
        }

        public PrefabContext build() {
            return new PrefabContext(this.contextType, this.properties);
        }
    }
}

