/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.context.ContextStore;
import cloud.prefab.context.PrefabContextSetReadable;
import java.util.Optional;
import java.util.concurrent.Callable;

public class PrefabContextHelper {
    private final ContextStore contextStore;

    public PrefabContextHelper(ContextStore contextStore) {
        this.contextStore = contextStore;
    }

    public PrefabContextHelper(ConfigClient configClient) {
        this(configClient.getContextStore());
    }

    public <T> T performWorkWithContext(PrefabContextSetReadable prefabContext, Callable<T> callable) throws Exception {
        try (PrefabContextScope ignored = this.performWorkWithAutoClosingContext(prefabContext);){
            T t = callable.call();
            return t;
        }
    }

    public void performWorkWithContext(PrefabContextSetReadable prefabContext, Runnable runnable) {
        try (PrefabContextScope ignored = this.performWorkWithAutoClosingContext(prefabContext);){
            runnable.run();
        }
    }

    private void resetContext(Optional<PrefabContextSetReadable> oldContext) {
        if (oldContext.isPresent()) {
            this.contextStore.setContext(oldContext.get());
        } else {
            this.contextStore.clearContext();
        }
    }

    public PrefabContextScope performWorkWithAutoClosingContext(PrefabContextSetReadable context) {
        return new PrefabContextScope(this.contextStore.setContext(context));
    }

    public class PrefabContextScope
    implements AutoCloseable {
        private final Optional<PrefabContextSetReadable> contextBackup;

        private PrefabContextScope(Optional<PrefabContextSetReadable> contextBackup) {
            this.contextBackup = contextBackup;
        }

        @Override
        public void close() {
            PrefabContextHelper.this.resetContext(this.contextBackup);
        }
    }
}

