/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;

public class PrefabContextSet
implements PrefabContextSetReadable {
    private ConcurrentSkipListMap<String, PrefabContext> contextByNameMap = new ConcurrentSkipListMap();

    public void addContext(PrefabContext prefabContext) {
        if (prefabContext != null) {
            this.contextByNameMap.put(prefabContext.getName().toLowerCase(), prefabContext);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.contextByNameMap.isEmpty();
    }

    @Override
    public Optional<PrefabContext> getByName(String contextType) {
        return Optional.ofNullable(this.contextByNameMap.get(contextType.toLowerCase()));
    }

    @Override
    public Iterable<PrefabContext> getContexts() {
        return ImmutableList.copyOf(this.contextByNameMap.values());
    }

    public static PrefabContextSet from(PrefabContext ... contexts) {
        PrefabContextSet set = new PrefabContextSet();
        for (PrefabContext context : contexts) {
            set.addContext(context);
        }
        return set;
    }

    public static PrefabContextSet from(Prefab.ContextSet contextSet) {
        PrefabContextSet set = new PrefabContextSet();
        contextSet.getContextsList().stream().forEach(p -> set.addContext(PrefabContext.fromProto(p)));
        return set;
    }

    public static PrefabContextSet convert(PrefabContextSetReadable prefabContextSetReadable) {
        if (prefabContextSetReadable instanceof PrefabContextSet) {
            return (PrefabContextSet)prefabContextSetReadable;
        }
        PrefabContextSet prefabContextSet = new PrefabContextSet();
        for (PrefabContext context : prefabContextSetReadable.getContexts()) {
            prefabContextSet.addContext(context);
        }
        return prefabContextSet;
    }

    public Prefab.ContextSet toProto() {
        Prefab.ContextSet.Builder bldr = Prefab.ContextSet.newBuilder();
        this.getContexts().forEach(prefabContext -> bldr.addContexts(prefabContext.toProtoContext()));
        return bldr.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrefabContextSet that = (PrefabContextSet)o;
        return Objects.equals(this.contextByNameMap, that.contextByNameMap);
    }

    public int hashCode() {
        return Objects.hash(this.contextByNameMap);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("contextByNameMap", this.contextByNameMap).toString();
    }
}

