/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSet;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface PrefabContextSetReadable {
    public static final PrefabContextSetReadable EMPTY = new PrefabContextSetReadable(){

        @Override
        public Optional<PrefabContext> getByName(String contextName) {
            return Optional.empty();
        }

        @Override
        public Iterable<PrefabContext> getContexts() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("contextByNameMap", (Object)"EMPTY").toString();
        }
    };

    public Optional<PrefabContext> getByName(String var1);

    public Iterable<PrefabContext> getContexts();

    public boolean isEmpty();

    public static PrefabContextSetReadable readOnlyContextSetView(final PrefabContextSet contextSet) {
        return new PrefabContextSetReadable(){

            @Override
            public Optional<PrefabContext> getByName(String contextName) {
                return contextSet.getByName(contextName);
            }

            @Override
            public Iterable<PrefabContext> getContexts() {
                return contextSet.getContexts();
            }

            @Override
            public boolean isEmpty() {
                return contextSet.isEmpty();
            }

            public String toString() {
                return contextSet.toString();
            }
        };
    }

    default public String getFingerPrint() {
        return StreamSupport.stream(this.getContexts().spliterator(), false).filter(c -> !c.getName().isBlank()).filter(c -> c.getProperties().containsKey("key")).sorted(Comparator.comparing(PrefabContext::getName)).map(c -> new StringBuilder().append(c.getName()).append("--").append(c.getProperties().get("key").toString().trim())).collect(Collectors.joining());
    }
}

