/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.FeatureFlagClient;
import cloud.prefab.client.Options;
import cloud.prefab.client.config.ConfigChangeListener;
import cloud.prefab.client.internal.ConfigClientImpl;
import cloud.prefab.client.internal.FeatureFlagClientImpl;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefabCloudClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PrefabCloudClient.class);
    private final Options options;
    private ConfigClientImpl configClient;
    private FeatureFlagClient featureFlagClient;
    private final AtomicBoolean closed;

    public PrefabCloudClient(Options options) {
        this.options = options;
        if (options.isLocalOnly()) {
            LOG.info("Initializing Prefab LocalOnly");
        } else if (options.isLocalDatafileMode()) {
            LOG.info("Initializing Prefab from local file {}", (Object)options.getLocalDatafile());
        } else {
            if (options.getApikey() == null || options.getApikey().isEmpty()) {
                throw new RuntimeException("PREFAB_API_KEY not set");
            }
            LOG.info("Initializing Prefab for apiKeyId {}", (Object)options.getApiKeyId());
        }
        this.closed = new AtomicBoolean(false);
    }

    public ConfigClient configClient() {
        return this.configClientImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigClientImpl configClientImpl() {
        if (this.configClient == null) {
            PrefabCloudClient prefabCloudClient = this;
            synchronized (prefabCloudClient) {
                if (this.configClient == null) {
                    this.configClient = new ConfigClientImpl(this, new ConfigChangeListener[0]);
                }
            }
        }
        return this.configClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureFlagClient featureFlagClient() {
        if (this.featureFlagClient == null) {
            PrefabCloudClient prefabCloudClient = this;
            synchronized (prefabCloudClient) {
                if (this.featureFlagClient == null) {
                    this.featureFlagClient = new FeatureFlagClientImpl(this.configClientImpl());
                }
            }
        }
        return this.featureFlagClient;
    }

    public Options getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.get()) {
            return;
        }
        PrefabCloudClient prefabCloudClient = this;
        synchronized (prefabCloudClient) {
            if (!this.closed.get()) {
                this.closed.set(true);
            }
        }
    }
}

