/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.config.logging;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public class MDCTargetedLoggingHelper {
    public static void logWithExclusiveContext(Map<String, String> context, Runnable runnable) {
        Map contextBackup = MDC.getCopyOfContextMap();
        try {
            MDC.setContextMap(context);
            runnable.run();
        }
        finally {
            MDCTargetedLoggingHelper.resetMDC(contextBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T logWithExclusiveContext(Map<String, String> context, Callable<T> callable) throws Exception {
        Map contextBackup = MDC.getCopyOfContextMap();
        try {
            MDC.setContextMap(context);
            T t = callable.call();
            return t;
        }
        finally {
            MDCTargetedLoggingHelper.resetMDC(contextBackup);
        }
    }

    public static TargetedLoggingContext logWithExclusiveContext(Map<String, String> context) {
        TargetedLoggingContext targetedLoggingContext = new TargetedLoggingContext(MDC.getCopyOfContextMap());
        MDC.setContextMap(context);
        return targetedLoggingContext;
    }

    public static void logWithMergedContext(Map<String, String> context, Runnable runnable) {
        Map contextBackup = MDC.getCopyOfContextMap();
        try {
            MDCTargetedLoggingHelper.mergeIntoMdc(context);
            runnable.run();
        }
        finally {
            MDCTargetedLoggingHelper.resetMDC(contextBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T logWithMergedContext(Map<String, String> context, Callable<T> callable) throws Exception {
        Map contextBackup = MDC.getCopyOfContextMap();
        try {
            MDCTargetedLoggingHelper.mergeIntoMdc(context);
            T t = callable.call();
            return t;
        }
        finally {
            MDCTargetedLoggingHelper.resetMDC(contextBackup);
        }
    }

    public static TargetedLoggingContext logWithMergedContext(Map<String, String> context) {
        TargetedLoggingContext targetedLoggingContext = new TargetedLoggingContext(MDC.getCopyOfContextMap());
        MDCTargetedLoggingHelper.mergeIntoMdc(context);
        return targetedLoggingContext;
    }

    private static void mergeIntoMdc(Map<String, String> context) {
        for (Map.Entry<String, String> entry : context.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static void resetMDC(Map<String, String> context) {
        if (context != null) {
            MDC.setContextMap(context);
        } else {
            MDC.clear();
        }
    }

    public static class TargetedLoggingContext
    implements AutoCloseable {
        private final Map<String, String> contextBackup;

        TargetedLoggingContext(Map<String, String> contextBackup) {
            this.contextBackup = contextBackup;
        }

        @Override
        public void close() {
            MDCTargetedLoggingHelper.resetMDC(this.contextBackup);
        }
    }
}

