/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigClient;
import cloud.prefab.client.Options;
import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.Provenance;
import cloud.prefab.client.config.logging.AbstractLoggingListener;
import cloud.prefab.client.internal.ContextWrapper;
import cloud.prefab.client.internal.MergedConfigData;
import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.annotations.VisibleForTesting;
import prefab.shaded.guava.collect.ImmutableMap;
import prefab.shaded.guava.collect.ImmutableSet;
import prefab.shaded.guava.collect.Sets;
import prefab.shaded.snakeyaml.Yaml;

public class ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigLoader.class);
    private static final ImmutableSet<Prefab.Criterion.CriterionOperator> PROPERTY_OPERATORS = Sets.immutableEnumSet((Enum)Prefab.Criterion.CriterionOperator.PROP_IS_ONE_OF, (Enum[])new Prefab.Criterion.CriterionOperator[]{Prefab.Criterion.CriterionOperator.PROP_IS_NOT_ONE_OF, Prefab.Criterion.CriterionOperator.PROP_ENDS_WITH_ONE_OF, Prefab.Criterion.CriterionOperator.PROP_ENDS_WITH_ONE_OF});
    private final Options options;
    private final ConcurrentMap<String, ConfigElement> apiConfig;
    private final AtomicLong highwaterMark;
    private final ImmutableMap<String, ConfigElement> classPathConfig;
    private final ImmutableMap<String, ConfigElement> overrideConfig;
    private final AtomicLong projectEnvId = new AtomicLong(0L);
    private final AtomicReference<ContextWrapper> configIncludedContext = new AtomicReference<ContextWrapper>(ContextWrapper.empty());
    private final ContextWrapper baseContext;

    public ConfigLoader(Options options) {
        this.options = options;
        this.apiConfig = new ConcurrentHashMap<String, ConfigElement>();
        this.highwaterMark = new AtomicLong(0L);
        this.classPathConfig = this.loadClasspathConfig();
        this.overrideConfig = this.loadOverrideConfig();
        this.baseContext = new ContextWrapper(options.getBaseContext().map(PrefabContextSetReadable::flattenToImmutableMap).orElse(Collections.emptyMap()));
    }

    public MergedConfigData calcConfig() {
        ImmutableMap.Builder<String, ConfigElement> builder = ImmutableMap.builder();
        builder.putAll(this.classPathConfig);
        builder.putAll(this.apiConfig);
        builder.putAll(this.overrideConfig);
        return new MergedConfigData(builder.buildKeepingLast(), this.projectEnvId.get(), this.baseContext, this.configIncludedContext.get());
    }

    private ContextWrapper getConfigIncludedContext(Prefab.Configs configs) {
        return new ContextWrapper(PrefabContextSet.from(configs.getDefaultContext()).flattenToImmutableMap());
    }

    public synchronized void setConfigs(Prefab.Configs configs, Provenance provenance) {
        for (Prefab.Config config : configs.getConfigsList()) {
            this.set(new ConfigElement(config, provenance), false);
        }
        this.recomputeHighWaterMark();
        this.projectEnvId.set(configs.getConfigServicePointer().getProjectEnvId());
        this.configIncludedContext.set(this.getConfigIncludedContext(configs));
    }

    @VisibleForTesting
    void set(ConfigElement configElement) {
        this.set(configElement, true);
    }

    private void set(ConfigElement configElement, boolean calculateHighWaterMark) {
        Prefab.Config config = configElement.getConfig();
        ConfigElement existing = (ConfigElement)this.apiConfig.get(config.getKey());
        if (existing == null || existing.getConfig().getId() <= config.getId()) {
            if (config.getRowsList().isEmpty()) {
                this.apiConfig.remove(config.getKey());
            } else {
                this.apiConfig.put(config.getKey(), configElement);
            }
        }
        if (calculateHighWaterMark) {
            this.recomputeHighWaterMark();
        }
    }

    private InputStream loadFileFromDiskOrResources(String filename) throws IOException {
        Path path = Paths.get(filename, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        InputStream streamFromResources = this.getClass().getResourceAsStream(filename);
        if (streamFromResources == null) {
            throw new RuntimeException("File %s not found, cannot proceed");
        }
        return streamFromResources;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Prefab.Configs loadFromJsonFile() {
        if (!this.options.isLocalDatafileMode()) {
            throw new IllegalStateException("no local data file specified");
        }
        LOG.info("Loading configs from {}", (Object)this.options.getLocalDatafile());
        try (InputStream inputStream = this.loadFileFromDiskOrResources(this.options.getLocalDatafile());){
            Prefab.Configs configs;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                Prefab.Configs.Builder builder = Prefab.Configs.newBuilder();
                JsonFormat.parser().merge((Reader)reader, (Message.Builder)builder);
                configs = builder.build();
            }
            return configs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void recomputeHighWaterMark() {
        long highwaterMarkDelta = this.apiConfig.values().stream().map(ConfigElement::getConfig).mapToLong(Prefab.Config::getId).max().orElse(0L);
        this.highwaterMark.set(highwaterMarkDelta);
    }

    private ImmutableMap<String, ConfigElement> loadClasspathConfig() {
        ImmutableMap.Builder<String, ConfigElement> builder = ImmutableMap.builder();
        if (!this.options.isLocalDatafileMode()) {
            for (String env : this.options.getAllPrefabEnvs()) {
                String file = String.format(".prefab.%s.config.yaml", env);
                try {
                    InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(file);
                    try {
                        if (resourceAsStream == null) {
                            LOG.warn("No default config file found {}", (Object)file);
                            continue;
                        }
                        this.loadFileTo(resourceAsStream, builder, ConfigClient.Source.CLASSPATH, file);
                    }
                    finally {
                        if (resourceAsStream == null) continue;
                        resourceAsStream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading config from file: " + file, e);
                }
            }
        }
        return builder.buildKeepingLast();
    }

    public static Prefab.ConfigValue configValueFromObj(String key, Object obj) {
        Prefab.ConfigValue.Builder valueBuilder = Prefab.ConfigValue.newBuilder();
        if (obj instanceof Boolean) {
            valueBuilder.setBool((Boolean)obj);
        } else if (obj instanceof Integer) {
            valueBuilder.setInt(((Integer)obj).intValue());
        } else if (obj instanceof Double) {
            valueBuilder.setDouble((Double)obj);
        } else if (obj instanceof String) {
            if (AbstractLoggingListener.keyIsLogLevel(key)) {
                valueBuilder.setLogLevel(Prefab.LogLevel.valueOf(((String)obj).toUpperCase()));
            } else {
                valueBuilder.setString((String)obj);
            }
        } else if (obj instanceof List) {
            Prefab.StringList.Builder stringListBuilder = Prefab.StringList.newBuilder();
            stringListBuilder.addAllValues((List)obj);
            valueBuilder.setStringList(stringListBuilder.build());
        }
        return valueBuilder.build();
    }

    private ConfigElement toFeatureFlag(String key, Map<String, Object> map, ConfigClient.Source source, String sourceLocation) {
        Object value = map.get("value");
        if (value == null) {
            throw new IllegalArgumentException(String.format("Feature flag with key '%s' must have a 'value' set", key));
        }
        Prefab.ConfigValue configValue = ConfigLoader.configValueFromObj(key, value);
        Prefab.ConditionalValue.Builder conditionalValueBuilder = Prefab.ConditionalValue.newBuilder().setValue(configValue);
        Object criteria = map.get("criteria");
        if (criteria instanceof Map) {
            conditionalValueBuilder.addCriteria(this.toCriterion(key, (Map)criteria));
        } else if (criteria instanceof List) {
            for (Object criterion : (List)criteria) {
                if (!(criterion instanceof Map)) continue;
                conditionalValueBuilder.addCriteria(this.toCriterion(key, (Map)criteria));
            }
        }
        return new ConfigElement(Prefab.Config.newBuilder().setConfigType(Prefab.ConfigType.FEATURE_FLAG).addRows(Prefab.ConfigRow.newBuilder().addValues(conditionalValueBuilder.build()).build()).build(), new Provenance(source, sourceLocation));
    }

    private Prefab.Criterion toCriterion(String key, Map<String, Object> map) {
        Object values;
        Prefab.Criterion.Builder builder = Prefab.Criterion.newBuilder();
        String operatorValue = (String)map.get("operator");
        if (operatorValue == null) {
            throw new IllegalArgumentException(String.format("Feature flag with key '%s' must have a 'operator' set in each criteria", key));
        }
        Prefab.Criterion.CriterionOperator operator = Prefab.Criterion.CriterionOperator.valueOf(operatorValue);
        builder.setOperator(operator);
        String property = (String)map.get("property");
        if (PROPERTY_OPERATORS.contains((Object)operator) && property == null) {
            throw new IllegalArgumentException(String.format("Feature flag with key '%s' must have a 'property' set in each criteria with a property operator", key));
        }
        if (property != null) {
            builder.setPropertyName(property);
        }
        if ((values = map.get("values")) == null) {
            throw new IllegalArgumentException(String.format("Feature flag with key '%s' must have 'values' set in each criteria", key));
        }
        if (values != null) {
            builder.setValueToMatch(ConfigLoader.configValueFromObj(key, values));
        }
        return builder.build();
    }

    private ConfigElement toValue(String key, Object obj, ConfigClient.Source source, String sourceLocation) {
        Prefab.ConfigValue value = ConfigLoader.configValueFromObj(key, obj);
        return new ConfigElement(Prefab.Config.newBuilder().addRows(Prefab.ConfigRow.newBuilder().addValues(Prefab.ConditionalValue.newBuilder().setValue(value).build()).build()).build(), new Provenance(source, sourceLocation));
    }

    private ImmutableMap<String, ConfigElement> loadOverrideConfig() {
        ImmutableMap.Builder<String, ConfigElement> builder = ImmutableMap.builder();
        if (!this.options.isLocalDatafileMode()) {
            File dir = new File(this.options.getConfigOverrideDir());
            for (String env : this.options.getAllPrefabEnvs()) {
                String fileName = String.format(".prefab.%s.config.yaml", env);
                File file = new File(dir, fileName);
                if (!file.exists()) continue;
                try (FileInputStream inputStream = new FileInputStream(file);){
                    this.loadFileTo(inputStream, builder, ConfigClient.Source.LOCAL_OVERRIDE, file.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return builder.buildKeepingLast();
    }

    private void loadFileTo(InputStream inputStream, ImmutableMap.Builder<String, ConfigElement> builder, ConfigClient.Source source, String sourceLocation) {
        LOG.info("Load File {}", (Object)sourceLocation);
        Yaml yaml = new Yaml();
        Map obj = (Map)yaml.load(inputStream);
        obj.forEach((k, v) -> this.loadKeyValue((String)k, v, builder, source, sourceLocation));
    }

    private void loadKeyValue(String k, Object v, ImmutableMap.Builder<String, ConfigElement> builder, ConfigClient.Source source, String sourceLocation) {
        if (v instanceof Map) {
            Map map = (Map)v;
            if (map.containsKey("feature_flag")) {
                builder.put(k, this.toFeatureFlag(k, map, source, sourceLocation));
            } else {
                for (Map.Entry nest : map.entrySet()) {
                    String nestedKey = String.format("%s.%s", k, nest.getKey());
                    if (((String)nest.getKey()).equals("_")) {
                        nestedKey = k;
                    }
                    this.loadKeyValue(nestedKey, nest.getValue(), builder, source, sourceLocation);
                }
            }
        } else {
            builder.put(k, this.toValue(k, v, source, sourceLocation));
        }
    }

    public long getHighwaterMark() {
        return this.highwaterMark.get();
    }
}

