/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.ConfigStore;
import cloud.prefab.client.config.ConfigElement;
import cloud.prefab.client.config.ConfigValueUtils;
import cloud.prefab.client.config.EvaluatedCriterion;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.internal.ContextWrapper;
import cloud.prefab.client.internal.IntRangeWrapper;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.WeightedValueEvaluator;
import cloud.prefab.domain.Prefab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.collect.Streams;

public class ConfigRuleEvaluator {
    public static final String CURRENT_TIME_KEY = "prefab.current-time";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigRuleEvaluator.class);
    private final ConfigStore configStore;
    private final WeightedValueEvaluator weightedValueEvaluator;

    public ConfigRuleEvaluator(ConfigStore configStoreImpl, WeightedValueEvaluator weightedValueEvaluator) {
        this.weightedValueEvaluator = weightedValueEvaluator;
        this.configStore = configStoreImpl;
    }

    public Optional<Match> getMatch(String key, LookupContext lookupContext) {
        ConfigElement configElement = this.configStore.getElement(key);
        if (configElement == null) {
            if (!key.startsWith("log-level")) {
                LOG.trace("No config value found for key {}", (Object)key);
            }
            return Optional.empty();
        }
        return this.getMatch(configElement, lookupContext);
    }

    public Optional<Match> getMatch(ConfigElement configElement, LookupContext lookupContext) {
        return this.getMatch(configElement, lookupContext, new LinkedList<Map<String, Prefab.ConfigValue>>());
    }

    private Optional<Match> getMatch(String key, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        if (!this.configStore.containsKey(key)) {
            if (!key.startsWith("log-level")) {
                LOG.trace("No config value found for key {}", (Object)key);
            }
            return Optional.empty();
        }
        ConfigElement configElement = this.configStore.getElement(key);
        return this.getMatch(configElement, lookupContext, rowPropertiesStack);
    }

    private Optional<Match> getMatch(ConfigElement configElement, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        return Streams.mapWithIndex(configElement.getRowsProjEnvFirst(this.configStore.getProjectEnvironmentId()), (configRow, rowIndex) -> {
            if (!configRow.getPropertiesMap().isEmpty()) {
                rowPropertiesStack.push(configRow.getPropertiesMap());
            }
            int conditionalValueIndex = 0;
            for (Prefab.ConditionalValue conditionalValue : configRow.getValuesList()) {
                Optional<Match> optionalMatch = this.evaluateConditionalValue(rowIndex, conditionalValue, conditionalValueIndex, lookupContext, rowPropertiesStack, configElement);
                if (optionalMatch.isPresent()) {
                    return optionalMatch.get();
                }
                ++conditionalValueIndex;
            }
            if (!configRow.getPropertiesMap().isEmpty()) {
                rowPropertiesStack.pop();
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
    }

    private Optional<Match> evaluateConditionalValue(long rowIndex, Prefab.ConditionalValue conditionalValue, int conditionalValueIndex, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowProperties, ConfigElement configElement) {
        ArrayList<EvaluatedCriterion> evaluatedCriteria = new ArrayList<EvaluatedCriterion>();
        for (Prefab.Criterion criterion : conditionalValue.getCriteriaList()) {
            for (EvaluatedCriterion evaluateCriterion : this.evaluateCriterionMatch(criterion, lookupContext, rowProperties)) {
                if (!evaluateCriterion.isMatch()) {
                    return Optional.empty();
                }
                evaluatedCriteria.add(evaluateCriterion);
            }
        }
        return Optional.of(this.simplifyToMatch(rowIndex, conditionalValue, conditionalValueIndex, configElement, lookupContext, evaluatedCriteria));
    }

    private Match simplifyToMatch(long rowIndex, Prefab.ConditionalValue selectedConditionalValue, int conditionalValueIndex, ConfigElement configElement, LookupContext lookupContext, List<EvaluatedCriterion> evaluatedCriteria) {
        if (selectedConditionalValue.getValue().hasWeightedValues()) {
            WeightedValueEvaluator.Result result = this.weightedValueEvaluator.toResult(selectedConditionalValue.getValue().getWeightedValues(), configElement.getConfig().getKey(), lookupContext);
            return new Match(result.getValue(), configElement, evaluatedCriteria, (int)rowIndex, conditionalValueIndex, Optional.of(result.getIndex()));
        }
        return new Match(selectedConditionalValue.getValue(), configElement, evaluatedCriteria, (int)rowIndex, conditionalValueIndex, Optional.empty());
    }

    private List<String> keyAndLowerCasedKey(String key) {
        String lowerCased = key.toLowerCase();
        if (lowerCased.equals(key)) {
            return Collections.singletonList(key);
        }
        return List.of(key, lowerCased);
    }

    private Optional<Prefab.ConfigValue> prop(String key, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        List<String> keysToLookup = this.keyAndLowerCasedKey(key);
        for (Map<String, Prefab.ConfigValue> rowProperties : rowPropertiesStack) {
            for (String keyToLookup : keysToLookup) {
                Prefab.ConfigValue rowPropValue = rowProperties.get(keyToLookup);
                if (rowPropValue == null) continue;
                return Optional.of(rowPropValue);
            }
        }
        Optional<Prefab.ConfigValue> configValueFromBaseContextMaybe = this.getPropFromContextWrapper(keysToLookup, this.configStore.getBaseContext());
        if (configValueFromBaseContextMaybe.isPresent()) {
            return configValueFromBaseContextMaybe;
        }
        Optional<Prefab.ConfigValue> configValueFromApiDefaultContext = this.getPropFromContextWrapper(keysToLookup, this.configStore.getConfigIncludedContext());
        if (configValueFromApiDefaultContext.isPresent()) {
            return configValueFromApiDefaultContext;
        }
        for (String keyToLookup : keysToLookup) {
            Prefab.ConfigValue valueFromLookupContext = lookupContext.getExpandedProperties().get(keyToLookup);
            if (valueFromLookupContext == null) continue;
            return Optional.of(valueFromLookupContext);
        }
        if (CURRENT_TIME_KEY.equals(key)) {
            return Optional.of(Prefab.ConfigValue.newBuilder().setInt(System.currentTimeMillis()).build());
        }
        return Optional.empty();
    }

    private Optional<Prefab.ConfigValue> getPropFromContextWrapper(List<String> keysToLookup, ContextWrapper contextWrapper) {
        for (String keyToLookup : keysToLookup) {
            Prefab.ConfigValue configValue = contextWrapper.getConfigValueMap().get(keyToLookup);
            if (configValue == null) continue;
            return Optional.of(configValue);
        }
        return Optional.empty();
    }

    List<EvaluatedCriterion> evaluateCriterionMatch(Prefab.Criterion criterion, LookupContext lookupContext) {
        return this.evaluateCriterionMatch(criterion, lookupContext, new LinkedList<Map<String, Prefab.ConfigValue>>());
    }

    List<EvaluatedCriterion> evaluateCriterionMatch(Prefab.Criterion criterion, LookupContext lookupContext, Deque<Map<String, Prefab.ConfigValue>> rowPropertiesStack) {
        Optional<Prefab.ConfigValue> prop = this.prop(criterion.getPropertyName(), lookupContext, rowPropertiesStack);
        Optional propStringValue = prop.flatMap(ConfigValueUtils::coerceToString);
        switch (criterion.getOperator()) {
            case ALWAYS_TRUE: {
                return List.of(new EvaluatedCriterion(criterion, true));
            }
            case HIERARCHICAL_MATCH: {
                if (prop.isPresent() && prop.get().hasString() && criterion.getValueToMatch().hasString()) {
                    String propertyString = prop.get().getString();
                    return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), this.hierarchicalMatch(propertyString, criterion.getValueToMatch().getString())));
                }
                return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), false));
            }
            case IN_SEG: {
                Optional<Match> evaluatedSegment = this.getMatch(criterion.getValueToMatch().getString(), lookupContext, rowPropertiesStack);
                if (evaluatedSegment.isPresent() && evaluatedSegment.get().getConfigValue().hasBool() && evaluatedSegment.get().getConfigValue().getBool()) {
                    return evaluatedSegment.get().getEvaluatedCriterion();
                }
                return List.of(new EvaluatedCriterion(criterion, "Missing Segment " + criterion.getValueToMatch().getString(), false));
            }
            case NOT_IN_SEG: {
                Optional<Prefab.ConfigValue> evaluatedNotSegment = this.getMatch(criterion.getValueToMatch().getString(), lookupContext).map(Match::getConfigValue);
                if (evaluatedNotSegment.isPresent() && evaluatedNotSegment.get().hasBool()) {
                    return List.of(new EvaluatedCriterion(criterion, criterion.getValueToMatch(), !evaluatedNotSegment.get().getBool()));
                }
                return List.of(new EvaluatedCriterion(criterion, "Missing Segment " + criterion.getValueToMatch().getString(), true));
            }
            case PROP_IS_ONE_OF: {
                if (propStringValue.isEmpty()) {
                    return List.of(new EvaluatedCriterion(criterion, false));
                }
                return List.of(new EvaluatedCriterion(criterion, (String)propStringValue.get(), criterion.getValueToMatch().getStringList().getValuesList().contains(propStringValue.get())));
            }
            case PROP_IS_NOT_ONE_OF: {
                if (propStringValue.isEmpty()) {
                    return List.of(new EvaluatedCriterion(criterion, false));
                }
                return List.of(new EvaluatedCriterion(criterion, (String)propStringValue.get(), !criterion.getValueToMatch().getStringList().getValuesList().contains(propStringValue.get())));
            }
            case PROP_ENDS_WITH_ONE_OF: {
                if (prop.isPresent() && prop.get().hasString()) {
                    boolean matched = criterion.getValueToMatch().getStringList().getValuesList().stream().anyMatch(value -> ((Prefab.ConfigValue)prop.get()).getString().endsWith((String)value));
                    return List.of(new EvaluatedCriterion(criterion, prop.get(), matched));
                }
                return List.of(new EvaluatedCriterion(criterion, false));
            }
            case PROP_DOES_NOT_END_WITH_ONE_OF: {
                if (prop.isPresent() && prop.get().hasString()) {
                    boolean matched;
                    return List.of(new EvaluatedCriterion(criterion, prop.get(), !(matched = criterion.getValueToMatch().getStringList().getValuesList().stream().anyMatch(value -> ((Prefab.ConfigValue)prop.get()).getString().endsWith((String)value)))));
                }
                return List.of(new EvaluatedCriterion(criterion, true));
            }
            case IN_INT_RANGE: {
                if (!prop.isPresent() || !prop.get().hasInt() || !criterion.getValueToMatch().hasIntRange()) break;
                return List.of(new EvaluatedCriterion(criterion, IntRangeWrapper.of(criterion.getValueToMatch().getIntRange()).contains(prop.get().getInt())));
            }
        }
        LOG.debug("Unexpected operator {} found in criterion {}", (Object)criterion.getOperator(), (Object)criterion);
        return List.of(new EvaluatedCriterion(criterion, false));
    }

    boolean hierarchicalMatch(String propertyString, String valueToMatch) {
        return propertyString.startsWith(valueToMatch);
    }

    public Collection<String> getKeys() {
        return this.configStore.getKeys();
    }

    public Collection<String> getKeysOfConfigType(Prefab.ConfigType configType) {
        return this.configStore.getElements().stream().map(ConfigElement::getConfig).filter(config -> config.getConfigType() == configType).map(Prefab.Config::getKey).collect(Collectors.toList());
    }

    public ConfigElement getRaw(String key) {
        return this.configStore.getElement(key);
    }

    public boolean containsKey(String key) {
        return this.configStore.containsKey(key);
    }
}

