/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSetReadable;
import cloud.prefab.domain.Prefab;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.annotations.VisibleForTesting;

public class ContextShapeAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(ContextShapeAggregator.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>> shapes;
    private final AtomicBoolean dirtyFlag = new AtomicBoolean(true);

    ContextShapeAggregator() {
        this.shapes = new ConcurrentHashMap();
    }

    void reportContextUsage(PrefabContextSetReadable prefabContextSetReadable) {
        Prefab.ContextShapes currentShapes = this.extractShapes(prefabContextSetReadable);
        for (Prefab.ContextShape contextShape : currentShapes.getShapesList()) {
            ConcurrentHashMap contextMap = this.shapes.computeIfAbsent(contextShape.getName(), key -> new ConcurrentHashMap());
            contextShape.getFieldTypesMap().forEach((key, value) -> {
                boolean dirtyFlagRaised;
                Integer oldValue = contextMap.put(key, value);
                if (!Objects.equals(oldValue, value) && (dirtyFlagRaised = this.dirtyFlag.compareAndSet(false, true)) && LOG.isTraceEnabled()) {
                    LOG.trace("dirty flag raised by context name: {} and property {}", (Object)contextShape.getName(), key);
                }
            });
        }
    }

    Optional<Prefab.ContextShapes> getShapesIfNewInfo() {
        if (this.dirtyFlag.get()) {
            return Optional.of(this.getShapes());
        }
        return Optional.empty();
    }

    Prefab.ContextShapes getShapes() {
        return this.buildProtoShapesFromShapeState();
    }

    @VisibleForTesting
    Prefab.ContextShapes buildProtoShapesFromShapeState() {
        Prefab.ContextShapes.Builder shapesBuilder = Prefab.ContextShapes.newBuilder();
        this.shapes.forEach((contextName, contextMap) -> {
            Prefab.ContextShape.Builder shapeBuilder = Prefab.ContextShape.newBuilder().setName((String)contextName);
            shapeBuilder.putAllFieldTypes((Map<String, Integer>)contextMap);
            shapesBuilder.addShapes(shapeBuilder);
        });
        return shapesBuilder.build();
    }

    private Prefab.ContextShapes extractShapes(PrefabContextSetReadable prefabContextSetReadable) {
        Prefab.ContextShapes.Builder shapesBuilder = Prefab.ContextShapes.newBuilder();
        StreamSupport.stream(prefabContextSetReadable.getContexts().spliterator(), false).map(PrefabContext::getShape).forEach(shapesBuilder::addShapes);
        return shapesBuilder.build();
    }
}

