/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.domain.Prefab;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggerStatsAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerStatsAggregator.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Clock clock;
    private final AtomicReference<LogCounts> currentLogCollection = new AtomicReference();
    private static final int DRAIN_SIZE = 25000;
    private static final int QUEUE_SIZE = 1000000000;
    private final List<Prefab.Logger> drain = new ArrayList<Prefab.Logger>(25000);
    private final LinkedBlockingQueue<Prefab.Logger> loggerCountQueue = new LinkedBlockingQueue(1000000000);
    private final LongAccumulator dropCounts = new LongAccumulator(Long::sum, 0L);

    LoggerStatsAggregator(Clock clock) {
        this.clock = clock;
        this.currentLogCollection.set(new LogCounts(clock.millis()));
    }

    LogCounts getAndResetStats() {
        return this.currentLogCollection.getAndSet(new LogCounts(this.clock.millis()));
    }

    void setStats(LogCounts logCounts) {
        this.currentLogCollection.set(logCounts);
    }

    void reportLoggerUsage(String loggerName, Prefab.LogLevel logLevel, long count) {
        Prefab.Logger.Builder loggerBuilder = Prefab.Logger.newBuilder().setLoggerName(loggerName);
        switch (logLevel) {
            case TRACE: {
                loggerBuilder.setTraces(count);
                break;
            }
            case DEBUG: {
                loggerBuilder.setDebugs(count);
                break;
            }
            case INFO: {
                loggerBuilder.setInfos(count);
                break;
            }
            case WARN: {
                loggerBuilder.setWarns(count);
                break;
            }
            case ERROR: {
                loggerBuilder.setErrors(count);
                break;
            }
            case FATAL: {
                loggerBuilder.setFatals(count);
            }
        }
        this.currentLogCollection.get().updateLoggerMap(Collections.singleton(loggerBuilder.build()));
    }

    static Prefab.Logger mergeLoggerCollection(Collection<Prefab.Logger> loggers) {
        Iterator<Prefab.Logger> iter = loggers.iterator();
        Prefab.Logger loggerToMutate = iter.next();
        long traces = loggerToMutate.getTraces();
        long debugs = loggerToMutate.getDebugs();
        long infos = loggerToMutate.getInfos();
        long warns = loggerToMutate.getWarns();
        long errors = loggerToMutate.getErrors();
        long fatals = loggerToMutate.getFatals();
        while (iter.hasNext()) {
            Prefab.Logger logger = iter.next();
            traces += logger.getTraces();
            debugs += logger.getDebugs();
            infos += logger.getInfos();
            warns += logger.getWarns();
            errors += logger.getErrors();
            fatals += logger.getFatals();
        }
        return loggerToMutate.toBuilder().setTraces(traces).setDebugs(debugs).setInfos(infos).setWarns(warns).setErrors(errors).setFatals(fatals).build();
    }

    static void updateFieldIfNotZero(long total, Consumer<Long> method) {
        if (total > 0L) {
            method.accept(total);
        }
    }

    static Prefab.Logger mergeLoggers(Prefab.Logger a, Prefab.Logger b) {
        Prefab.Logger.Builder bldr = Prefab.Logger.newBuilder().setLoggerName(a.getLoggerName());
        LoggerStatsAggregator.updateFieldIfNotZero(a.getTraces() + b.getTraces(), bldr::setTraces);
        LoggerStatsAggregator.updateFieldIfNotZero(a.getDebugs() + b.getDebugs(), bldr::setDebugs);
        LoggerStatsAggregator.updateFieldIfNotZero(a.getInfos() + b.getInfos(), bldr::setInfos);
        LoggerStatsAggregator.updateFieldIfNotZero(a.getWarns() + b.getWarns(), bldr::setWarns);
        LoggerStatsAggregator.updateFieldIfNotZero(a.getErrors() + b.getErrors(), bldr::setErrors);
        LoggerStatsAggregator.updateFieldIfNotZero(a.getFatals() + b.getFatals(), bldr::setFatals);
        return bldr.build();
    }

    static class LogCounts {
        private final long startTime;
        private final Map<String, Prefab.Logger> loggerMap;
        private final ReentrantLock mutex = new ReentrantLock();

        LogCounts(long startTime) {
            this.startTime = startTime;
            this.loggerMap = new HashMap<String, Prefab.Logger>();
        }

        long getStartTime() {
            return this.startTime;
        }

        Map<String, Prefab.Logger> getLoggerMap() {
            try {
                this.mutex.lock();
                Map<String, Prefab.Logger> map = this.loggerMap;
                return map;
            }
            finally {
                this.mutex.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateLoggerMap(Collection<Prefab.Logger> loggers) {
            try {
                this.mutex.lock();
                for (Prefab.Logger logger : loggers) {
                    this.loggerMap.merge(logger.getLoggerName(), logger, LoggerStatsAggregator::mergeLoggers);
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }
}

