/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.client.internal;

import cloud.prefab.client.Options;
import cloud.prefab.client.config.Match;
import cloud.prefab.client.internal.ContextShapeAggregator;
import cloud.prefab.client.internal.ExampleContextBuffer;
import cloud.prefab.client.internal.LoggerStatsAggregator;
import cloud.prefab.client.internal.LookupContext;
import cloud.prefab.client.internal.MatchStatsAggregator;
import cloud.prefab.client.internal.PrefabHttpClient;
import cloud.prefab.client.internal.TelemetryUploader;
import cloud.prefab.domain.Prefab;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prefab.shaded.guava.util.concurrent.MoreExecutors;
import prefab.shaded.guava.util.concurrent.ThreadFactoryBuilder;

public class TelemetryManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryManager.class);
    static final int OUTPUT_QUEUE_SIZE = 10;
    static final int INPUT_QUEUE_SIZE = 1000000;
    private static final int DRAIN_SIZE = 25000;
    private final List<IncomingTelemetryEvent> drain = new ArrayList<IncomingTelemetryEvent>(25000);
    private final LongAccumulator droppedEventCount = new LongAccumulator(Long::sum, 0L);
    private final LoggerStatsAggregator loggerStatsAggregator;
    private final MatchStatsAggregator matchStatsAggregator;
    private final ContextShapeAggregator contextShapeAggregator;
    private final ExampleContextBuffer exampleContextBuffer;
    private final Options options;
    private final TelemetryUploader telemetryUploader;
    private final LinkedBlockingQueue<OutputBuffer> outputQueue = new LinkedBlockingQueue(10);
    private final LinkedBlockingQueue<IncomingTelemetryEvent> inputQueue = new LinkedBlockingQueue(1000000);
    private final Clock clock;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong recordingPeriodStartTime = new AtomicLong();

    TelemetryManager(LoggerStatsAggregator loggerStatsAggregator, MatchStatsAggregator matchStatsAggregator, ContextShapeAggregator contextShapeAggregator, ExampleContextBuffer exampleContextBuffer, PrefabHttpClient prefabHttpClient, Options options, Clock clock) {
        this.loggerStatsAggregator = loggerStatsAggregator;
        this.matchStatsAggregator = matchStatsAggregator;
        this.contextShapeAggregator = contextShapeAggregator;
        this.exampleContextBuffer = exampleContextBuffer;
        this.options = options;
        this.telemetryUploader = new TelemetryUploader(this.outputQueue, prefabHttpClient, options);
        this.clock = clock;
    }

    void start(int autoFlushSeconds) {
        if (this.running.compareAndSet(false, true)) {
            this.telemetryUploader.start();
            ThreadFactory aggregatorFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefab-telemetry-manager-%d").build();
            Thread aggregatorThread = aggregatorFactory.newThread(this::eventLoop);
            aggregatorThread.setDaemon(true);
            aggregatorThread.setUncaughtExceptionHandler((t, e) -> LOG.error("uncaught exception in thread t {}", (Object)t.getName(), (Object)e));
            aggregatorThread.start();
            this.recordingPeriodStartTime.set(this.clock.millis());
            if (autoFlushSeconds > 0) {
                ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "prefab-telemetry-manager-autoflush"));
                ScheduledExecutorService executorService = MoreExecutors.getExitingScheduledExecutorService(executor, 100L, TimeUnit.MILLISECONDS);
                executorService.scheduleWithFixedDelay(() -> {
                    try {
                        this.requestFlush();
                    }
                    catch (Exception e) {
                        LOG.debug("error requesting flush", (Throwable)e);
                    }
                }, autoFlushSeconds, autoFlushSeconds, TimeUnit.SECONDS);
            }
        }
    }

    void start() {
        this.start(this.options.getTelemetryUploadIntervalSeconds());
    }

    void reportMatch(String configKey, @Nullable Match match, LookupContext lookupContext) {
        if (match == null) {
            return;
        }
        long now = this.clock.millis();
        if (!this.inputQueue.offer(new MatchEvent(now, configKey, match, lookupContext))) {
            this.droppedEventCount.accumulate(1L);
        }
    }

    void reportLoggerUsage(String loggerName, Prefab.LogLevel logLevel, long count) {
        if (!this.inputQueue.offer(new LoggingEvent(this.clock.millis(), loggerName, logLevel, count))) {
            this.droppedEventCount.accumulate(1L);
        }
    }

    private void handleLogEvent(IncomingTelemetryEvent incomingTelemetryEvent) {
        LoggingEvent loggingEvent = (LoggingEvent)incomingTelemetryEvent;
        if (this.options.isCollectLoggerCounts()) {
            this.loggerStatsAggregator.reportLoggerUsage(loggingEvent.loggerName, loggingEvent.logLevel, loggingEvent.count);
        }
    }

    private void handleMatchEvent(IncomingTelemetryEvent telemetryEvent) {
        MatchEvent matchEvent = (MatchEvent)telemetryEvent;
        if (!matchEvent.lookupContext.getPrefabContextSet().isEmpty()) {
            if (this.options.isCollectContextShapeEnabled()) {
                this.contextShapeAggregator.reportContextUsage(matchEvent.lookupContext.getPrefabContextSet());
            }
            if (this.options.isCollectExampleContextEnabled()) {
                this.exampleContextBuffer.recordContext(matchEvent.timestamp, matchEvent.lookupContext.getPrefabContextSet());
            }
        }
        if (matchEvent.match != null && this.options.isCollectEvaluationSummaries() && !matchEvent.match.getConfigValue().getConfidential()) {
            this.matchStatsAggregator.recordMatch(matchEvent.match, matchEvent.timestamp);
        }
    }

    private void handleFlush(IncomingTelemetryEvent telemetryEvent) {
        FlushEvent flushEvent = (FlushEvent)telemetryEvent;
        MatchStatsAggregator.StatsAggregate matchStats = this.matchStatsAggregator.getAndResetStatsAggregate();
        Set<Prefab.ExampleContext> exampleContexts = this.exampleContextBuffer.getAndResetContexts();
        LoggerStatsAggregator.LogCounts loggerCounts = this.loggerStatsAggregator.getAndResetStats();
        Optional<Prefab.ContextShapes> contextShapesMaybe = this.contextShapeAggregator.getShapesIfNewInfo();
        long currentDroppedEventCount = this.droppedEventCount.getThenReset();
        long previousReportingPeriodStart = this.recordingPeriodStartTime.get();
        long now = this.clock.millis();
        this.recordingPeriodStartTime.set(now);
        if (!this.outputQueue.offer(new OutputBuffer(previousReportingPeriodStart, now, exampleContexts, matchStats, loggerCounts.getLoggerMap().values(), contextShapesMaybe, currentDroppedEventCount, flushEvent.future))) {
            this.recordingPeriodStartTime.set(previousReportingPeriodStart);
            this.matchStatsAggregator.setStatsAggregate(matchStats);
            this.droppedEventCount.accumulate(currentDroppedEventCount);
            this.recordingPeriodStartTime.set(previousReportingPeriodStart);
            this.exampleContextBuffer.setContexts(exampleContexts);
            this.loggerStatsAggregator.setStats(loggerCounts);
            flushEvent.future.complete(false);
        }
    }

    CompletableFuture<Boolean> requestFlush() {
        FlushEvent flushEvent = new FlushEvent(this.clock.millis());
        if (!this.inputQueue.offer(flushEvent)) {
            return CompletableFuture.completedFuture(false);
        }
        return flushEvent.future;
    }

    void eventLoop() {
        do {
            try {
                IncomingTelemetryEvent incomingTelemetryEvent = this.inputQueue.poll(500L, TimeUnit.MILLISECONDS);
                if (incomingTelemetryEvent == null) continue;
                this.drain.add(incomingTelemetryEvent);
                this.inputQueue.drainTo(this.drain, 24999);
                for (IncomingTelemetryEvent telemetryEvent : this.drain) {
                    switch (telemetryEvent.eventType) {
                        case LOG: {
                            this.handleLogEvent(telemetryEvent);
                            break;
                        }
                        case MATCH: {
                            this.handleMatchEvent(telemetryEvent);
                            break;
                        }
                        case FLUSH: {
                            this.handleFlush(telemetryEvent);
                        }
                    }
                }
                this.drain.clear();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } while (this.running.get());
    }

    @Override
    public void close() throws Exception {
        this.running.set(false);
    }

    static class MatchEvent
    extends IncomingTelemetryEvent {
        private final String configKey;
        @Nullable
        Match match;
        LookupContext lookupContext;

        MatchEvent(long timestamp, String configKey, @Nullable Match match, LookupContext lookupContext) {
            super(IncomingTelemetryEvent.EventType.MATCH, timestamp);
            this.configKey = configKey;
            this.match = match;
            this.lookupContext = lookupContext;
        }
    }

    static class LoggingEvent
    extends IncomingTelemetryEvent {
        private final String loggerName;
        private final Prefab.LogLevel logLevel;
        private final long count;
        Match match;
        LookupContext lookupContext;

        LoggingEvent(long timestamp, String loggerName, Prefab.LogLevel logLevel, long count) {
            super(IncomingTelemetryEvent.EventType.LOG, timestamp);
            this.loggerName = loggerName;
            this.logLevel = logLevel;
            this.count = count;
        }
    }

    static class FlushEvent
    extends IncomingTelemetryEvent {
        private final CompletableFuture<Boolean> future = new CompletableFuture();

        FlushEvent(long timestamp) {
            super(IncomingTelemetryEvent.EventType.FLUSH, timestamp);
        }
    }

    static class OutputBuffer {
        static final Logger LOG = LoggerFactory.getLogger(OutputBuffer.class);
        private final Collection<Prefab.Logger> loggerCollection;
        private final Optional<Prefab.ContextShapes> contextShapesMaybe;
        private final long droppedEventCount;
        private final CompletableFuture<Boolean> uploadCompleteFuture;
        private final long startTime;
        private final long endTime;
        Set<Prefab.ExampleContext> recentlySeenContexts;
        MatchStatsAggregator.StatsAggregate statsAggregate;

        public OutputBuffer(long startTime, long endTime, Set<Prefab.ExampleContext> recentlySeenContexts, MatchStatsAggregator.StatsAggregate statsAggregate, Collection<Prefab.Logger> loggerCollection, Optional<Prefab.ContextShapes> contextShapes, long droppedEventCount, CompletableFuture<Boolean> uploadCompleteFuture) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.recentlySeenContexts = recentlySeenContexts;
            this.statsAggregate = statsAggregate;
            this.loggerCollection = loggerCollection;
            this.contextShapesMaybe = contextShapes;
            this.droppedEventCount = droppedEventCount;
            this.uploadCompleteFuture = uploadCompleteFuture;
        }

        Prefab.TelemetryEvents toTelemetryEvents() {
            Prefab.TelemetryEvents.Builder telemetryEventsBuilder = Prefab.TelemetryEvents.newBuilder();
            if (!this.recentlySeenContexts.isEmpty()) {
                LOG.debug("adding {} recently seen contexts to telemetry bundle", (Object)this.recentlySeenContexts.size());
                telemetryEventsBuilder.addEvents(Prefab.TelemetryEvent.newBuilder().setExampleContexts(Prefab.ExampleContexts.newBuilder().addAllExamples(this.recentlySeenContexts).build()).build());
            } else {
                LOG.debug("No recently seen contexts for telemetry bundle");
            }
            if (this.droppedEventCount > 0L) {
                telemetryEventsBuilder.addEvents(Prefab.TelemetryEvent.newBuilder().setClientStats(Prefab.ClientStats.newBuilder().setDroppedEventCount(this.droppedEventCount).setStart(this.startTime).setEnd(this.endTime).build()));
            }
            if (!this.statsAggregate.getCounterData().isEmpty()) {
                telemetryEventsBuilder.addEvents(Prefab.TelemetryEvent.newBuilder().setSummaries(this.statsAggregate.toProto()));
            }
            if (!this.loggerCollection.isEmpty()) {
                Prefab.LoggersTelemetryEvent telemetryEvent = Prefab.LoggersTelemetryEvent.newBuilder().addAllLoggers(this.loggerCollection).build();
                telemetryEventsBuilder.addEvents(Prefab.TelemetryEvent.newBuilder().setLoggers(telemetryEvent));
            }
            this.contextShapesMaybe.ifPresent(contextShapes -> {
                if (!contextShapes.getShapesList().isEmpty()) {
                    telemetryEventsBuilder.addEvents(Prefab.TelemetryEvent.newBuilder().setContextShapes((Prefab.ContextShapes)contextShapes));
                }
            });
            return telemetryEventsBuilder.build();
        }

        void complete() {
            this.uploadCompleteFuture.complete(true);
        }
    }

    static class IncomingTelemetryEvent {
        EventType eventType;
        long timestamp;

        IncomingTelemetryEvent(EventType eventType, long timestamp) {
            this.eventType = eventType;
            this.timestamp = timestamp;
        }

        static enum EventType {
            MATCH,
            LOG,
            FLUSH;

        }
    }
}

