/*
 * Decompiled with CFR 0.152.
 */
package cloud.prefab.context;

import cloud.prefab.context.PrefabContext;
import cloud.prefab.context.PrefabContextSet;
import cloud.prefab.domain.Prefab;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import prefab.shaded.guava.base.MoreObjects;
import prefab.shaded.guava.collect.ImmutableMap;
import prefab.shaded.guava.collect.Streams;

public interface PrefabContextSetReadable {
    public static final PrefabContextSetReadable EMPTY = new PrefabContextSetReadable(){

        @Override
        public Optional<PrefabContext> getByName(String contextName) {
            return Optional.empty();
        }

        @Override
        public Iterable<PrefabContext> getContexts() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("contextByNameMap", "EMPTY").toString();
        }
    };

    public Optional<PrefabContext> getByName(String var1);

    public Iterable<PrefabContext> getContexts();

    public boolean isEmpty();

    default public Map<String, Prefab.ConfigValue> flattenToImmutableMap() {
        return Streams.stream(this.getContexts()).sorted(Comparator.comparing(PrefabContext::getName)).flatMap(context -> context.getNameQualifiedProperties().entrySet().stream().sorted(Map.Entry.comparingByKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (existingValue, newValue) -> newValue));
    }

    public static PrefabContextSetReadable readOnlyContextSetView(final PrefabContextSet contextSet) {
        return new PrefabContextSetReadable(){

            @Override
            public Optional<PrefabContext> getByName(String contextName) {
                return contextSet.getByName(contextName);
            }

            @Override
            public Iterable<PrefabContext> getContexts() {
                return contextSet.getContexts();
            }

            @Override
            public boolean isEmpty() {
                return contextSet.isEmpty();
            }

            public String toString() {
                return contextSet.toString();
            }
        };
    }

    default public String getFingerPrint() {
        return StreamSupport.stream(this.getContexts().spliterator(), false).filter(c -> !c.getName().isBlank()).filter(c -> c.getProperties().containsKey("key")).sorted(Comparator.comparing(PrefabContext::getName)).map(c -> new StringBuilder().append(c.getName()).append("--").append(c.getProperties().get("key").toString().trim())).collect(Collectors.joining());
    }
}

