/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import prefab.shaded.failsafe.AsyncExecutionImpl;
import prefab.shaded.failsafe.Call;
import prefab.shaded.failsafe.CallImpl;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.Functions;
import prefab.shaded.failsafe.Policy;
import prefab.shaded.failsafe.SyncExecutionImpl;
import prefab.shaded.failsafe.event.EventListener;
import prefab.shaded.failsafe.event.ExecutionCompletedEvent;
import prefab.shaded.failsafe.function.AsyncRunnable;
import prefab.shaded.failsafe.function.CheckedRunnable;
import prefab.shaded.failsafe.function.CheckedSupplier;
import prefab.shaded.failsafe.function.ContextualRunnable;
import prefab.shaded.failsafe.function.ContextualSupplier;
import prefab.shaded.failsafe.internal.EventHandler;
import prefab.shaded.failsafe.internal.util.Assert;
import prefab.shaded.failsafe.spi.AsyncExecutionInternal;
import prefab.shaded.failsafe.spi.ExecutionResult;
import prefab.shaded.failsafe.spi.FailsafeFuture;
import prefab.shaded.failsafe.spi.Scheduler;

public class FailsafeExecutor<R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    private Executor executor;
    final List<? extends Policy<R>> policies;
    private volatile EventHandler<R> completeHandler;
    private volatile EventHandler<R> failureHandler;
    private volatile EventHandler<R> successHandler;
    final BiConsumer<ExecutionResult<R>, ExecutionContext<R>> completionHandler = (result, context) -> {
        if (this.successHandler != null && result.getSuccessAll()) {
            this.successHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        } else if (this.failureHandler != null && !result.getSuccessAll()) {
            this.failureHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        }
        if (this.completeHandler != null) {
            this.completeHandler.handle((ExecutionResult<R>)result, (ExecutionContext<R>)context);
        }
    };

    FailsafeExecutor(List<? extends Policy<R>> policies) {
        this.policies = policies;
    }

    public List<? extends Policy<R>> getPolicies() {
        return this.policies;
    }

    public <P extends Policy<R>> FailsafeExecutor<R> compose(P innerPolicy) {
        Assert.notNull(innerPolicy, "innerPolicy");
        ArrayList<Policy<R>> composed = new ArrayList<Policy<R>>(this.policies);
        composed.add(innerPolicy);
        return new FailsafeExecutor<R>(composed);
    }

    public <T extends R> T get(CheckedSupplier<T> supplier) {
        return (T)this.call(Functions.toCtxSupplier(supplier));
    }

    public <T extends R> T get(ContextualSupplier<T, T> supplier) {
        return this.call(Assert.notNull(supplier, "supplier"));
    }

    public Call<Void> newCall(ContextualRunnable<Void> runnable) {
        return this.callSync(Functions.toCtxSupplier(runnable));
    }

    public <T extends R> Call<T> newCall(ContextualSupplier<T, T> supplier) {
        return this.callSync(Assert.notNull(supplier, "supplier"));
    }

    public <T extends R> CompletableFuture<T> getAsync(CheckedSupplier<T> supplier) {
        return this.callAsync(future -> Functions.getPromise(Functions.toCtxSupplier(supplier), this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getAsync(ContextualSupplier<T, T> supplier) {
        return this.callAsync(future -> Functions.getPromise(supplier, this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getAsyncExecution(AsyncRunnable<T> runnable) {
        return this.callAsync(future -> Functions.getPromiseExecution(runnable, this.executor), true);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> supplier) {
        return this.callAsync(future -> Functions.getPromiseOfStage(Functions.toCtxSupplier(supplier), future, this.executor), false);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(ContextualSupplier<T, ? extends CompletionStage<T>> supplier) {
        return this.callAsync(future -> Functions.getPromiseOfStage(supplier, future, this.executor), false);
    }

    public void run(CheckedRunnable runnable) {
        this.call(Functions.toCtxSupplier(runnable));
    }

    public void run(ContextualRunnable<Void> runnable) {
        this.call(Functions.toCtxSupplier(runnable));
    }

    public CompletableFuture<Void> runAsync(CheckedRunnable runnable) {
        return this.callAsync(future -> Functions.getPromise(Functions.toCtxSupplier(runnable), this.executor), false);
    }

    public CompletableFuture<Void> runAsync(ContextualRunnable<Void> runnable) {
        return this.callAsync(future -> Functions.getPromise(Functions.toCtxSupplier(runnable), this.executor), false);
    }

    public CompletableFuture<Void> runAsyncExecution(AsyncRunnable<Void> runnable) {
        return this.callAsync(future -> Functions.getPromiseExecution(runnable, this.executor), true);
    }

    public FailsafeExecutor<R> onComplete(EventListener<ExecutionCompletedEvent<R>> listener) {
        this.completeHandler = EventHandler.ofExecutionCompleted(Assert.notNull(listener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> onFailure(EventListener<ExecutionCompletedEvent<R>> listener) {
        this.failureHandler = EventHandler.ofExecutionCompleted(Assert.notNull(listener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> onSuccess(EventListener<ExecutionCompletedEvent<R>> listener) {
        this.successHandler = EventHandler.ofExecutionCompleted(Assert.notNull(listener, "listener"));
        return this;
    }

    public FailsafeExecutor<R> with(ScheduledExecutorService scheduledExecutorService) {
        this.scheduler = Scheduler.of(Assert.notNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    public FailsafeExecutor<R> with(ExecutorService executorService) {
        this.scheduler = Scheduler.of(Assert.notNull(executorService, "executorService"));
        return this;
    }

    public FailsafeExecutor<R> with(Executor executor) {
        Assert.notNull(executor, "executor");
        if (executor instanceof ExecutorService) {
            this.with((ExecutorService)executor);
        } else {
            this.executor = executor;
        }
        return this;
    }

    public FailsafeExecutor<R> with(Scheduler scheduler) {
        this.scheduler = Assert.notNull(scheduler, "scheduler");
        return this;
    }

    private <T> T call(ContextualSupplier<T, T> innerSupplier) {
        SyncExecutionImpl execution = new SyncExecutionImpl(this, this.scheduler, null, Functions.get(innerSupplier, this.executor));
        return (T)execution.executeSync();
    }

    private <T> Call<T> callSync(ContextualSupplier<T, T> innerSupplier) {
        CallImpl call = new CallImpl();
        new SyncExecutionImpl(this, this.scheduler, call, Functions.get(innerSupplier, this.executor));
        return call;
    }

    private <T> CompletableFuture<T> callAsync(Function<FailsafeFuture<T>, Function<AsyncExecutionInternal<T>, CompletableFuture<ExecutionResult<T>>>> innerFn, boolean asyncExecution) {
        FailsafeFuture future = new FailsafeFuture(this.completionHandler);
        AsyncExecutionImpl execution = new AsyncExecutionImpl(this.policies, this.scheduler, future, asyncExecution, innerFn.apply(future));
        future.setExecution(execution);
        execution.executeAsync();
        return future;
    }
}

