/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import prefab.shaded.failsafe.DelayablePolicyBuilder;
import prefab.shaded.failsafe.PolicyListeners;
import prefab.shaded.failsafe.RetryPolicy;
import prefab.shaded.failsafe.RetryPolicyConfig;
import prefab.shaded.failsafe.event.EventListener;
import prefab.shaded.failsafe.event.ExecutionAttemptedEvent;
import prefab.shaded.failsafe.event.ExecutionCompletedEvent;
import prefab.shaded.failsafe.event.ExecutionScheduledEvent;
import prefab.shaded.failsafe.function.CheckedBiPredicate;
import prefab.shaded.failsafe.function.CheckedPredicate;
import prefab.shaded.failsafe.internal.RetryPolicyImpl;
import prefab.shaded.failsafe.internal.util.Assert;
import prefab.shaded.failsafe.internal.util.Durations;

public class RetryPolicyBuilder<R>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R>
implements PolicyListeners<RetryPolicyBuilder<R>, R> {
    private static final int DEFAULT_MAX_RETRIES = 2;

    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    RetryPolicyBuilder(RetryPolicyConfig<R> config) {
        super(new RetryPolicyConfig<R>(config));
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(CheckedBiPredicate<R, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(completionPredicate);
        return this;
    }

    public RetryPolicyBuilder<R> abortIf(CheckedPredicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> exception) {
        Assert.notNull(exception, "exception");
        return this.abortOn(Arrays.asList(exception));
    }

    @SafeVarargs
    public final RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> ... exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(exceptions.length > 0, "exceptions cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(exceptions));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> exceptions) {
        Assert.notNull(exceptions, "exceptions");
        Assert.isTrue(!exceptions.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(exceptions));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(CheckedPredicate<? extends Throwable> abortPredicate) {
        Assert.notNull(abortPredicate, "abortPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(abortPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortWhen(R result) {
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(result));
        return this;
    }

    public RetryPolicyBuilder<R> onAbort(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).abortListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetriesExceeded(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retriesExceededListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetryScheduled(EventListener<ExecutionScheduledEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryScheduledListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay) {
        return this.withBackoff(delay, maxDelay, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit) {
        return this.withBackoff(delay, maxDelay, chronoUnit, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        return this.withBackoff(Duration.of(delay, chronoUnit), Duration.of(maxDelay, chronoUnit), delayFactor);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay, double delayFactor) {
        Assert.notNull(delay, "delay");
        Assert.notNull(maxDelay, "maxDelay");
        delay = Durations.ofSafeNanos(delay);
        maxDelay = Durations.ofSafeNanos(maxDelay);
        Assert.isTrue(!delay.isNegative() && !delay.isZero(), "The delay must be > 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        Assert.isTrue(delay.toNanos() < maxDelay.toNanos(), "delay must be < the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be > 1", new Object[0]);
        ((RetryPolicyConfig)this.config).delay = delay;
        ((RetryPolicyConfig)this.config).maxDelay = maxDelay;
        ((RetryPolicyConfig)this.config).delayFactor = delayFactor;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        delay = Durations.ofSafeNanos(delay);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delay.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delay must be >= the jitter duration", new Object[0]);
        super.withDelay(delay);
        ((RetryPolicyConfig)this.config).maxDelay = null;
        ((RetryPolicyConfig)this.config).delayMin = null;
        ((RetryPolicyConfig)this.config).delayMax = null;
        return this;
    }

    public RetryPolicyBuilder<R> withDelay(long delayMin, long delayMax, ChronoUnit chronoUnit) {
        return this.withDelay(Duration.of(delayMin, chronoUnit), Duration.of(delayMax, chronoUnit));
    }

    public RetryPolicyBuilder<R> withDelay(Duration delayMin, Duration delayMax) {
        Assert.notNull(delayMin, "delayMin");
        Assert.notNull(delayMax, "delayMax");
        delayMin = Durations.ofSafeNanos(delayMin);
        delayMax = Durations.ofSafeNanos(delayMax);
        Assert.isTrue(!delayMin.isNegative() && !delayMin.isZero(), "delayMin must be > 0", new Object[0]);
        Assert.isTrue(!delayMax.isNegative() && !delayMax.isZero(), "delayMax must be > 0", new Object[0]);
        Assert.isTrue(delayMin.toNanos() < delayMax.toNanos(), "delayMin must be < delayMax", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delayMax.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delayMax must be < the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null || delayMin.toNanos() >= ((RetryPolicyConfig)this.config).jitter.toNanos(), "delayMin must be >= the jitter duration", new Object[0]);
        ((RetryPolicyConfig)this.config).delayMin = delayMin;
        ((RetryPolicyConfig)this.config).delayMax = delayMax;
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxDelay = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = jitterFactor;
        ((RetryPolicyConfig)this.config).jitter = null;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(Duration jitter) {
        Assert.notNull(jitter, "jitter");
        jitter = Durations.ofSafeNanos(jitter);
        Assert.isTrue(jitter.toNanos() > 0L, "jitter must be > 0", new Object[0]);
        boolean validJitter = ((RetryPolicyConfig)this.config).delayMin != null ? jitter.toNanos() <= ((RetryPolicyConfig)this.config).delayMin.toNanos() : ((RetryPolicyConfig)this.config).delay == Duration.ZERO || jitter.toNanos() < ((RetryPolicyConfig)this.config).delay.toNanos();
        Assert.state(validJitter, "jitter must be < the minimum configured delay", new Object[0]);
        ((RetryPolicyConfig)this.config).jitter = jitter;
        ((RetryPolicyConfig)this.config).jitterFactor = 0.0;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(maxAttempts >= -1, "maxAttempts must be >= -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        maxDuration = Durations.ofSafeNanos(maxDuration);
        Assert.state(maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), "maxDuration must be > the delay", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMax == null || maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delayMax.toNanos(), "maxDuration must be > the max random delay", new Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = maxDuration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be >= to -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxRetries;
        return this;
    }
}

