/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import prefab.shaded.failsafe.CircuitBreaker;
import prefab.shaded.failsafe.CircuitBreakerConfig;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.event.CircuitBreakerStateChangedEvent;
import prefab.shaded.failsafe.event.EventListener;
import prefab.shaded.failsafe.internal.CircuitBreakerExecutor;
import prefab.shaded.failsafe.internal.CircuitState;
import prefab.shaded.failsafe.internal.ClosedState;
import prefab.shaded.failsafe.internal.HalfOpenState;
import prefab.shaded.failsafe.internal.OpenState;
import prefab.shaded.failsafe.spi.DelayablePolicy;
import prefab.shaded.failsafe.spi.FailurePolicy;
import prefab.shaded.failsafe.spi.PolicyExecutor;

public class CircuitBreakerImpl<R>
implements CircuitBreaker<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final CircuitBreakerConfig<R> config;
    protected final AtomicReference<CircuitState<R>> state = new AtomicReference();

    public CircuitBreakerImpl(CircuitBreakerConfig<R> config) {
        this.config = config;
        this.state.set(new ClosedState(this));
    }

    @Override
    public CircuitBreakerConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public boolean tryAcquirePermit() {
        return this.state.get().tryAcquirePermit();
    }

    @Override
    public void close() {
        this.transitionTo(CircuitBreaker.State.CLOSED, this.config.getCloseListener(), null);
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.state.get().getState();
    }

    @Override
    public int getExecutionCount() {
        return this.state.get().getStats().getExecutionCount();
    }

    @Override
    public Duration getRemainingDelay() {
        return this.state.get().getRemainingDelay();
    }

    @Override
    public long getFailureCount() {
        return this.state.get().getStats().getFailureCount();
    }

    @Override
    public int getFailureRate() {
        return this.state.get().getStats().getFailureRate();
    }

    @Override
    public int getSuccessCount() {
        return this.state.get().getStats().getSuccessCount();
    }

    @Override
    public int getSuccessRate() {
        return this.state.get().getStats().getSuccessRate();
    }

    @Override
    public void halfOpen() {
        this.transitionTo(CircuitBreaker.State.HALF_OPEN, this.config.getHalfOpenListener(), null);
    }

    @Override
    public boolean isClosed() {
        return CircuitBreaker.State.CLOSED.equals((Object)this.getState());
    }

    @Override
    public boolean isHalfOpen() {
        return CircuitBreaker.State.HALF_OPEN.equals((Object)this.getState());
    }

    @Override
    public boolean isOpen() {
        return CircuitBreaker.State.OPEN.equals((Object)this.getState());
    }

    @Override
    public void open() {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), null);
    }

    @Override
    public void recordFailure() {
        this.recordExecutionFailure(null);
    }

    @Override
    public void recordException(Throwable exception) {
        this.recordResult(null, exception);
    }

    @Override
    public void recordResult(R result) {
        this.recordResult(result, null);
    }

    @Override
    public void recordSuccess() {
        this.state.get().recordSuccess();
    }

    public String toString() {
        return this.getState().toString();
    }

    protected void recordResult(R result, Throwable exception) {
        if (this.isFailure(result, exception)) {
            this.state.get().recordFailure(null);
        } else {
            this.state.get().recordSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transitionTo(CircuitBreaker.State newState, EventListener<CircuitBreakerStateChangedEvent> listener, ExecutionContext<R> context) {
        CircuitBreaker.State currentState;
        boolean transitioned = false;
        CircuitBreakerImpl circuitBreakerImpl = this;
        synchronized (circuitBreakerImpl) {
            currentState = this.getState();
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this));
                        break;
                    }
                    case OPEN: {
                        Duration computedDelay = this.computeDelay(context);
                        this.state.set(new OpenState<R>(this, this.state.get(), computedDelay != null ? computedDelay : this.config.getDelay()));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.accept(new CircuitBreakerStateChangedEvent(currentState));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void recordExecutionFailure(ExecutionContext<R> context) {
        this.state.get().recordFailure(context);
    }

    protected void open(ExecutionContext<R> context) {
        this.transitionTo(CircuitBreaker.State.OPEN, this.config.getOpenListener(), context);
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new CircuitBreakerExecutor(this, policyIndex);
    }
}

