/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.event.EventListener;
import prefab.shaded.failsafe.event.ExecutionAttemptedEvent;
import prefab.shaded.failsafe.event.ExecutionCompletedEvent;
import prefab.shaded.failsafe.event.ExecutionScheduledEvent;
import prefab.shaded.failsafe.spi.ExecutionResult;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionCompletedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionAttemptedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionScheduledEvent(result.getResult(), result.getException(), Duration.ofNanos(result.getDelay()), context));
    }
}

