/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.util.concurrent.atomic.AtomicInteger;
import prefab.shaded.failsafe.CircuitBreaker;
import prefab.shaded.failsafe.CircuitBreakerConfig;
import prefab.shaded.failsafe.ExecutionContext;
import prefab.shaded.failsafe.internal.CircuitBreakerImpl;
import prefab.shaded.failsafe.internal.CircuitState;
import prefab.shaded.failsafe.internal.CircuitStats;

class HalfOpenState<R>
extends CircuitState<R> {
    protected final AtomicInteger permittedExecutions = new AtomicInteger();

    public HalfOpenState(CircuitBreakerImpl<R> breaker) {
        super(breaker, CircuitStats.create(breaker, HalfOpenState.capacityFor(breaker), false, null));
        this.permittedExecutions.set(HalfOpenState.capacityFor(breaker));
    }

    @Override
    public boolean tryAcquirePermit() {
        return this.permittedExecutions.getAndUpdate(permits -> permits == 0 ? 0 : permits - 1) > 0;
    }

    @Override
    public void releasePermit() {
        this.permittedExecutions.incrementAndGet();
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, HalfOpenState.capacityFor(this.breaker), false, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext<R> context) {
        boolean failuresExceeded;
        boolean successesExceeded;
        int successThreshold = this.config.getSuccessThreshold();
        if (successThreshold != 0) {
            int successThresholdingCapacity = this.config.getSuccessThresholdingCapacity();
            successesExceeded = this.stats.getSuccessCount() >= successThreshold;
            failuresExceeded = this.stats.getFailureCount() > successThresholdingCapacity - successThreshold;
        } else {
            int failureRateThreshold = this.config.getFailureRateThreshold();
            if (failureRateThreshold != 0) {
                boolean executionThresholdExceeded = this.stats.getExecutionCount() >= this.config.getFailureExecutionThreshold();
                failuresExceeded = executionThresholdExceeded && this.stats.getFailureRate() >= failureRateThreshold;
                successesExceeded = executionThresholdExceeded && this.stats.getSuccessRate() > 100 - failureRateThreshold;
            } else {
                int failureThresholdingCapacity = this.config.getFailureThresholdingCapacity();
                int failureThreshold = this.config.getFailureThreshold();
                failuresExceeded = this.stats.getFailureCount() >= failureThreshold;
                boolean bl = successesExceeded = this.stats.getSuccessCount() > failureThresholdingCapacity - failureThreshold;
            }
        }
        if (successesExceeded) {
            this.breaker.close();
        } else if (failuresExceeded) {
            this.breaker.open(context);
        }
    }

    private static int capacityFor(CircuitBreaker<?> breaker) {
        int capacity = ((CircuitBreakerConfig)breaker.getConfig()).getSuccessThresholdingCapacity();
        if (capacity == 0) {
            capacity = ((CircuitBreakerConfig)breaker.getConfig()).getFailureExecutionThreshold();
        }
        if (capacity == 0) {
            capacity = ((CircuitBreakerConfig)breaker.getConfig()).getFailureThresholdingCapacity();
        }
        return capacity;
    }
}

