/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import prefab.shaded.failsafe.RateLimitExceededException;
import prefab.shaded.failsafe.RateLimiterConfig;
import prefab.shaded.failsafe.internal.RateLimiterImpl;
import prefab.shaded.failsafe.spi.ExecutionResult;
import prefab.shaded.failsafe.spi.FailsafeFuture;
import prefab.shaded.failsafe.spi.PolicyExecutor;
import prefab.shaded.failsafe.spi.Scheduler;

public class RateLimiterExecutor<R>
extends PolicyExecutor<R> {
    private final RateLimiterImpl<R> rateLimiter;
    private final Duration maxWaitTime;

    public RateLimiterExecutor(RateLimiterImpl<R> rateLimiter, int policyIndex) {
        super(rateLimiter, policyIndex);
        this.rateLimiter = rateLimiter;
        this.maxWaitTime = ((RateLimiterConfig)rateLimiter.getConfig()).getMaxWaitTime();
    }

    @Override
    protected ExecutionResult<R> preExecute() {
        try {
            return this.rateLimiter.tryAcquirePermit(this.maxWaitTime) ? null : ExecutionResult.exception(new RateLimitExceededException(this.rateLimiter));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ExecutionResult.exception(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture promise = new CompletableFuture();
        long waitNanos = this.rateLimiter.reservePermits(1, this.maxWaitTime);
        if (waitNanos == -1L) {
            promise.complete(ExecutionResult.exception(new RateLimitExceededException(this.rateLimiter)));
        } else {
            try {
                ScheduledFuture<?> permitWaitFuture = scheduler.schedule(() -> {
                    promise.complete(ExecutionResult.none());
                    return null;
                }, waitNanos, TimeUnit.NANOSECONDS);
                future.setCancelFn(this, (mayInterrupt, cancelResult) -> {
                    promise.complete((ExecutionResult)cancelResult);
                    permitWaitFuture.cancel((boolean)mayInterrupt);
                });
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
        }
        return promise;
    }
}

