/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import java.time.Duration;

abstract class RateLimiterStats {
    final Stopwatch stopwatch;

    RateLimiterStats(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    abstract long acquirePermits(long var1, Duration var3);

    boolean exceedsMaxWaitTime(long waitNanos, Duration maxWaitTime) {
        return maxWaitTime != null && waitNanos > maxWaitTime.toNanos();
    }

    Duration getElapsed() {
        return Duration.ofNanos(this.stopwatch.elapsedNanos());
    }

    abstract void reset();

    static class Stopwatch {
        private long startTime = System.nanoTime();

        Stopwatch() {
        }

        long elapsedNanos() {
            return System.nanoTime() - this.startTime;
        }

        void reset() {
            this.startTime = System.nanoTime();
        }
    }
}

