/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.failsafe.internal;

import prefab.shaded.failsafe.RetryPolicy;
import prefab.shaded.failsafe.RetryPolicyConfig;
import prefab.shaded.failsafe.function.CheckedBiPredicate;
import prefab.shaded.failsafe.internal.RetryPolicyExecutor;
import prefab.shaded.failsafe.spi.DelayablePolicy;
import prefab.shaded.failsafe.spi.FailurePolicy;
import prefab.shaded.failsafe.spi.PolicyExecutor;

public class RetryPolicyImpl<R>
implements RetryPolicy<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final RetryPolicyConfig<R> config;

    public RetryPolicyImpl(RetryPolicyConfig<R> config) {
        this.config = config;
    }

    @Override
    public RetryPolicyConfig<R> getConfig() {
        return this.config;
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (CheckedBiPredicate<R, Throwable> predicate : this.config.getAbortConditions()) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RetryPolicyExecutor(this, policyIndex);
    }
}

