/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.collect;

import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    @CheckForNull
    private T nextOrNull;

    protected AbstractSequentialIterator(@CheckForNull T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    @CheckForNull
    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (this.nextOrNull == null) {
            throw new NoSuchElementException();
        }
        T oldNext = this.nextOrNull;
        this.nextOrNull = this.computeNext(oldNext);
        return oldNext;
    }
}

