/*
 * Decompiled with CFR 0.152.
 */
package prefab.shaded.guava.collect;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import prefab.shaded.guava.annotations.GwtCompatible;
import prefab.shaded.guava.annotations.GwtIncompatible;
import prefab.shaded.guava.base.Preconditions;
import prefab.shaded.guava.collect.CollectSpliterators;
import prefab.shaded.guava.collect.ElementTypesAreNonnullByDefault;
import prefab.shaded.guava.collect.ImmutableAsList;
import prefab.shaded.guava.collect.ImmutableCollection;
import prefab.shaded.guava.collect.ImmutableList;
import prefab.shaded.guava.collect.ImmutableSet;
import prefab.shaded.guava.collect.UnmodifiableIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.asList().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1297, this::get);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.asList().copyIntoArray(dst, offset);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableAsList<E>(){

            @Override
            public E get(int index) {
                return IndexedImmutableSet.this.get(index);
            }

            @Override
            boolean isPartialView() {
                return IndexedImmutableSet.this.isPartialView();
            }

            @Override
            public int size() {
                return IndexedImmutableSet.this.size();
            }

            @Override
            ImmutableCollection<E> delegateCollection() {
                return IndexedImmutableSet.this;
            }
        };
    }
}

